/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.0                               *
 * *************************************/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <string.h>
#include <math.h>
#include "image.h"

#ifdef WIN32
#pragma pack( push, enter_bitmap_def1 )
#pragma pack(1)

typedef struct tagBITMAPFILEHEADER {
        WORD    bfType;
        DWORD   bfSize;
        WORD    bfReserved1;
        WORD    bfReserved2;
        DWORD   bfOffBits;
} BITMAPFILEHEADER;

typedef struct tagBITMAPINFOHEADER{
	    DWORD  biWidth;
	    DWORD  biHeight;
		WORD   biPlanes;
		WORD   biBitCount;
		DWORD  biCompression;
		DWORD  biSizeImage;
		DWORD  biXPelsPerMeter;
		DWORD  biYPelsPerMeter;
		DWORD  biClrUsed;
		DWORD  biClrImportant;
} BITMAPINFOHEADER;

typedef struct tagBITMAPCOREHEADER {
        WORD    bcWidth;
        WORD    bcHeight;
        WORD    bcPlanes;
        WORD    bcBitCount;
} BITMAPCOREHEADER;

#pragma pack( pop, enter_bitmap_def1  )
#endif

#ifdef __GNUG__
struct tagBITMAPFILEHEADER {
        WORD    bfType;
        DWORD   bfSize;
        WORD    bfReserved1;
        WORD    bfReserved2;
        DWORD   bfOffBits;
} __attribute__((packed));
typedef struct tagBITMAPFILEHEADER BITMAPFILEHEADER;

struct tagBITMAPINFOHEADER{
	    DWORD  biWidth;
	    DWORD  biHeight;
		WORD   biPlanes;
		WORD   biBitCount;
		DWORD  biCompression;
		DWORD  biSizeImage;
		DWORD  biXPelsPerMeter;
		DWORD  biYPelsPerMeter;
		DWORD  biClrUsed;
		DWORD  biClrImportant;
} __attribute__((packed));
typedef struct tagBITMAPINFOHEADER BITMAPINFOHEADER;

struct tagBITMAPCOREHEADER {
        WORD    bcWidth;
        WORD    bcHeight;
        WORD    bcPlanes;
        WORD    bcBitCount;
} __attribute__((packed));
typedef struct tagBITMAPCOREHEADER BITMAPCOREHEADER;

#endif

DWORD invertbitsL(DWORD l)
{
	DWORD r;
	char *a=(char*)&l,*b=(char*)&r;
	b[0]=a[3]; b[1]=a[2]; b[2]=a[1]; b[3]=a[0];
	return r;
};

WORD invertbitsS(WORD s)
{
	WORD r;
	char *a=(char*)&s,*b=(char*)&r;
	b[0]=a[1]; b[1]=a[0];
	return r;
};

image::image(char *name) : fgl(NULL)
{
	BYTE *tmp,*tmp2;
	FILE *fr;
	BITMAPFILEHEADER bmf;
	BITMAPCOREHEADER bmc;
	BITMAPINFOHEADER bmi;
	DWORD a,w;
    int h;

	if ((fr=fopen(name,"rb"))!=NULL)
	{		
		fread(&bmf,sizeof(BITMAPFILEHEADER),1,fr);
		fread(&a,sizeof(a),1,fr);
#ifdef __sun__
		a=invertbitsL(a);
#endif

		if (a==12)
		{
			fread(&bmc,sizeof(BITMAPCOREHEADER),1,fr);
#ifdef __sun__	
			Width=invertbitsS(bmc.bcWidth);
			Height=invertbitsS(bmc.bcHeight);
#else	
			Width=bmc.bcWidth;
			Height=bmc.bcHeight;
#endif

			fseek(fr,256*3,SEEK_CUR);
		} else
		{
			fread(&bmi,sizeof(BITMAPINFOHEADER),1,fr);
#ifdef __sun	
			Width=(WORD)invertbitsL(bmi.biWidth);
			Height=(WORD)invertbitsL(bmi.biHeight);
                        bmi.biClrUsed=invertbitsL(bmi.biClrUsed);
#else
			Width=(WORD)bmi.biWidth;
			Height=(WORD)bmi.biHeight;
#endif
			fseek(fr,bmi.biClrUsed*4,SEEK_CUR);
		};

		if ((Width%4)==0) w=Width;
		else w=Width+4-Width%4;		
		Size=Width*Height;
		gl=(BYTE*)malloc(Size);
		if (gl==NULL)
		{
	        fprintf(stderr,"img_load: out of memory.\n");
	        exit(211);
		};
		h=Height-1;
		while (h>=0)
		{
			tmp=gl+Width*h;
			fread(tmp,Width,1,fr);			
			if (w!=Width) fseek(fr,w-Width,SEEK_CUR);			
			h--;
		}
		fclose(fr);
		tmp=gl; tmp2=tmp+Size; while (tmp!=tmp2) { *tmp=MIN(254,*tmp); tmp++; };
		return;
	};
	printf("image '%s' not found.\n",name); exit(236);
};

void image::save(char *name)
{
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	FILE *fw;
	
	DWORD a,w;
	int i,h;
	BYTE buffer[4];
	long s;
	BYTE *p;

	if ((Width%4)==0) w=Width;
	else w=Width+4-Width%4;
	s=w*Height;

	fw=fopen(name,"wb");

#ifdef __sun__
	bmfh.bfType=invertbitsS(19778);
    bmfh.bfReserved1=0;
    bmfh.bfReserved2=0;
    bmfh.bfOffBits=invertbitsL(sizeof(BITMAPFILEHEADER)+4+sizeof(BITMAPINFOHEADER)+256*4);
	bmfh.bfSize=invertbitsL(bmfh.bfOffBits+s);
	fwrite(&bmfh,sizeof(BITMAPFILEHEADER),1,fw);
	a=invertbitsL(40); fwrite(&a,sizeof(a),1,fw);
    bmih.biWidth=invertbitsL(Width);
    bmih.biHeight=invertbitsL(Height);
    bmih.biPlanes=invertbitsS(1);
    bmih.biBitCount=invertbitsS(8);
	bmih.biCompression=0;
	bmih.biSizeImage=invertbitsL(s);
	bmih.biXPelsPerMeter=0;
	bmih.biYPelsPerMeter=0;
	bmih.biClrUsed=invertbitsL(256);
	bmih.biClrImportant=0;
#else
	bmfh.bfType=19778;
    bmfh.bfReserved1=0;
    bmfh.bfReserved2=0;
    bmfh.bfOffBits=sizeof(BITMAPFILEHEADER)+4+sizeof(BITMAPINFOHEADER)+256*4;
	bmfh.bfSize=bmfh.bfOffBits+s;
	fwrite(&bmfh,sizeof(BITMAPFILEHEADER),1,fw);
	a=40; fwrite(&a,sizeof(a),1,fw);
    bmih.biWidth=Width;
    bmih.biHeight=Height;
    bmih.biPlanes=1;
    bmih.biBitCount=8;
	bmih.biCompression=0;
	bmih.biSizeImage=s;
	bmih.biXPelsPerMeter=0;
	bmih.biYPelsPerMeter=0;
	bmih.biClrUsed=256;
	bmih.biClrImportant=0; 
#endif

    buffer[3]=0;
	fwrite(&bmih,sizeof(BITMAPINFOHEADER),1,fw);	
	for (i=0; i<256; i++) 
	{
		buffer[0]=(BYTE)i; buffer[1]=(BYTE)i; buffer[2]=(BYTE)i;
		fwrite(&buffer,4,1,fw);
	};
	buffer[0]=0; buffer[1]=0; buffer[2]=0; buffer[3]=0;
	h=Height-1;	
    while (h>=0) 
	{
		p=gl+Width*h;
		fwrite(p,Width,1,fw);
		if (w!=Width) fwrite(&buffer,1,w-Width,fw);
		h--;
	};
	fclose(fw);
};

void image::find_max(WORD *x,WORD *y)
{
	BYTE *glend=gl+Size,*glf=gl,*gli=gl+1,a=0,b;
	DWORD l;
	
	while (glend!=gli) 
	{
	    b=abs(*(gli++)-128);
		if ((b>a)&&(b!=255)) { glf=gli-1; a=b; };
    };
	l=(DWORD)(glf-gl);
	*x=(WORD)(l%Width);
	*y=(WORD)(l/Width);
};

void image::find_min(WORD *x,WORD *y)
{
	BYTE *glend,*glf,*gli;
	DWORD l;
	
	glend=gl+Size; glf=gl; gli=gl+1;
	while (glend!=gli) if (*(gli++)<*glf) glf=gli;	
	l=(DWORD)(glf-gl);
	*x=(WORD)(l%Width);
	*y=(WORD)(l/Width);
};

image::~image()
{
	if (gl!=NULL) free(gl);
	if (fgl!=NULL) free(fgl);
};

image::image(WORD _Width,WORD _Height,BYTE c) : fgl(NULL), Width(_Width),
 Height(_Height), Size(_Width*_Height)
{
	gl=(BYTE*)malloc(Size*sizeof(BYTE));
	if (gl==NULL)
	{
        fprintf(stderr,"img_create: out of memory.\n");
        exit(212);
	};	
//	for (i=0;i<Size;i++) gl[i]=c;
    memset(gl,c,Size);
};

void image::initFrom(image *im)
{
	if (gl!=NULL) free(gl);
	if (fgl!=NULL) free(fgl);
    fgl=NULL;
    Width=im->Width;
    Height=im->Height;
    Size=im->Width*im->Height;
    if (Size==0) {gl=NULL; return;}
	gl=(BYTE*)malloc(Size*sizeof(BYTE));
	if (gl==NULL)
	{
        fprintf(stderr,"img_initFrom: out of memory.\n");
        exit(212);
	};	
    memcpy(gl,im->gl,Size);
}

image::image(image *im,double scaleX, double scaleY) : fgl(NULL)
{	
	WORD i,j;
	DWORD incX,incY,counterY,counterX,a;
	BYTE *indexD,*indexS,*indexSstartline,*indexDstartline;
	DWORD *surface,*surfaceStartline,*surfaceStartimage;
	BYTE b;

	Width=(WORD)ceil(im->Width*scaleX);
	Height=(WORD)ceil(im->Height*scaleY);
	Size=Width*Height;
	gl=(BYTE*)malloc(Size*sizeof(BYTE));
    if (gl==NULL)
    {
        fprintf(stderr,"img_resize: out of memory.\n");
        exit(214);
    };
	if ((scaleX==1)&&(scaleY==1))
	{
		memcpy(gl,im->gl,Size);
		gravityH=im->gravityH;
		gravityW=im->gravityW;
	    total=im->total;
	    minGL=im->minGL;
	    maxGL=im->maxGL;
	    pixBsurN=im->pixBsurN;
	    Surface=im->Surface;
		return;
	}
	if (scaleX<1)
	{
		incX=(DWORD)(65536*scaleX);
		incY=(DWORD)(65536*scaleY);
		memset(gl,0,Size);
		indexDstartline=gl;
		indexS=im->gl;
		counterY=0;
		surfaceStartline=surfaceStartimage=(DWORD*)malloc(Size*sizeof(DWORD));
        if (surfaceStartline==NULL)
        {
            fprintf(stderr,"img_resize: out of memory.\n");
            exit(214);
        };
		memset(surfaceStartline,0,Size*sizeof(DWORD));
		for (j=0; j<im->Height; j++)
		{
			counterX=0;
			indexD=indexDstartline;
			surface=surfaceStartline;
			for (i=0; i<im->Width; i++)
			{
				a=(DWORD)(counterX>>16);
				indexD[a]++;
				surface[a]+=*(indexS++);
				counterX+=incX;
			};
			counterY+=incY;
			if (counterY>65535)
			{
				indexDstartline+=Width;
				surfaceStartline+=Width;
				counterY&=65535;
			};
		};
		indexD=gl; indexS=indexD+Size;
		surface=surfaceStartimage;
		while (indexD!=indexS)
		{
			b=((*indexD!=0)?(BYTE)((*surface)/(*indexD)):(BYTE)128);
			if (b==255) *indexD=254; else *indexD=b;
			indexD++;
			surface++;
		};
		free(surfaceStartimage);
	} else
	{
		indexSstartline=im->gl;
		indexD=gl;
		incX=(DWORD)(65536/scaleX);
		incY=(DWORD)(65536/scaleY);
		counterY=0;
		for (j=0; j<Height; j++)
		{			
			counterX=0;
			indexS=indexSstartline;
			for (i=0; i<Width; i++)
			{
				(*(indexD++))=indexS[(int)(counterX>>16)];
				counterX+=incX;
			};
			counterY+=incY;
			if (counterY>65535) 
			{
				indexSstartline+=im->Width;
				counterY&=65535;
			};
		};
	};
};
/*
void image::init_fast_access()
{
	int i;
	BYTE *t=gl;
	fgl=(BYTE**)malloc(Height*sizeof(BYTE*));
	for (i=0; i<Height; i++, t+=Width) fgl[i]=t;
};
*/
BYTE *image::flood_fill(WORD x, WORD y,BYTE cons)
{
	DWORD xb;
	BYTE *tmpstop2=gl+y*Width,*tmpstop=tmpstop2+Width-1,*tmpu=tmpstop2+x-1,*tmpstopu;
	register BYTE *tmp=tmpstop2+x,c=*tmp,u;

	while (((c<128-cons)||(c>=128+cons))&&(tmp!=tmpstop )&&(c!=255)) { *tmp=255; c=*(++tmp); };
	tmpstop=tmp-1; 
	if (x!=0)
	{
		tmp=tmpu; c=*tmp;
		while (((c<128-cons)||(c>=128+cons))&&(tmp!=tmpstop2)&&(c!=255)) { *tmp=255; c=*(--tmp); };	
		xb=x+tmp-tmpu; tmpu=tmp+1;
	} else
	{
		xb=x; tmpu++;
	};

	if ((y!=0)&&(*tmpu==255))
	{	
		tmpstopu=tmpstop-Width;
		tmp=tmpu-Width;
		u=128;
		while (tmp<=tmpstopu)
		{
			c=*(tmp++);
			if (((c>=128+cons)||(c< 128-cons))&&
				(u< 128+cons)&&(u>=128-cons)&&
				(c!=255)) tmp=flood_fill((WORD)(xb+tmp-tmpu+Width-1),y-1,cons);
			u=c;
		};
	};
	if ((y!=Height-1)&&(*tmpu==255))
	{
		tmpstopu=tmpstop+Width;
		tmp=tmpu+Width;
		u=128;
		while (tmp<=tmpstopu)
		{
			c=*(tmp++);
			if (((c>=128+cons)||(c< 128-cons))&&
				(u< 128+cons)&&(u>=128-cons)&&
				(c!=255)) tmp=flood_fill((WORD)(xb+tmp-tmpu-Width-1),y+1,cons);
			u=c;
		};
	};
	return tmpstop+1;
};

void image::analyse()
{
	WORD i;
	DWORD sum=0,blanc=0,noir=0;
	DWORD *tmp,*tmp2;
	BYTE *indexB=gl,*indexE=gl+Size,*indexEOL=gl+Width,a,min=128,max=128;

	total=0;

	tmp=(DWORD*)malloc((MAX(Height,Width)+1)*sizeof(long)); tmp2=tmp;
	if (tmp==NULL)
	{
	   fprintf(stderr,"img_analyse: out of memory.\n");
	   exit(215);
	};
	while (indexB!=indexE) // calcule la moyenne sur toutes les lignes dans vm
	{					   // calcule total: la somme de tous les points de l'image 
						   // calcule minGL et maxGL 
						   // calcule Surface
		if (indexB==indexEOL)
		{
			*(tmp2++)=sum;
			total+=sum;
			sum=0; 
			indexEOL=indexEOL+Width;
		};
		a=*indexB;
		min=MIN(min,a);
		max=MAX(max,a);
		if (a>128) blanc++;
		if (a<128) noir++;
		sum+=abs((int)a-128);
		indexB++;
	};
	Surface=blanc+noir;
	minGL=(double)(128-min)/128.0;
	maxGL=(double)(max-128)/128.0;
	noir=MAX(noir,1); pixBsurN=MIN(2,((double)blanc)/noir);
	*tmp2=sum; total+=sum;
	sum=0; tmp2=tmp;	/* calcule le centre de gravit en Hauteur de l'image */
	for (i=0; i<Height; i++) { sum+=*(tmp2++)*i; };
	gravityH=(WORD)floor(sum/(double)total+0.5);

	sum=0; indexB=gl; indexEOL=indexB+Size; indexE=gl+Size+Width-1; i=0; tmp2=tmp;
	while (indexB!=indexE) /* calcule la moyenne sur toutes les colonnes dans hm*/
	{
		if (indexB==indexEOL)
		{
			*(tmp2++)=sum;
			sum=0;
			indexEOL++;
			indexB=gl+(++i);
		};
		sum+=abs((int)*indexB-128);
		indexB+=Width;
	};
	*tmp2=sum;

	sum=0; tmp2=tmp; /* calcule le centre de gravit en Width de l'image */
	for (i=0; i<Width; i++) { sum+=*(tmp2++)*i; }
	gravityW=(WORD)floor(sum/(double)total+0.5);

	free(tmp);
};

void image::analyse_simple()
{	
	DWORD blanc=0,noir=0;	
	BYTE *indexB=gl,*indexE=gl+Size,a,min=128,max=128;

    Surface=0; total=0;

	while (indexB!=indexE) // calcule la moyenne sur toutes les lignes dans vm
	{					   // calcule total: la somme de tous les points de l'image 
		a=*indexB;
		total+=abs((int)a-128);
		min=MIN(min,a);
		max=MAX(max,a);
		if (a>128) blanc++;
		if (a<128) noir++;
		indexB++;
	};
	Surface=blanc+noir;
	minGL=(double)(128-min)/128.0;
	maxGL=(double)(max-128)/128.0;
	noir=MAX(noir,1); pixBsurN=MIN(2,blanc/(double)noir);
};

void image::imCeil(double ratio,BYTE treshold)
{
	DWORD *vm,*hm,*vmtmp;
	BYTE b,*tmp=gl,*tmpeol,*tmpstop,*mgl,*mgltmp;
	DWORD sum,i,j,k,hole=0;
	int a;
	BYTE secours;
	WORD H,W,T;

	total=0;
	vmtmp=vm=(DWORD*)malloc((Height+Width)*sizeof(DWORD)+Size*sizeof(BYTE));
	if (vm==NULL)
	{
        fprintf(stderr,"img_Ceil: out of memory.\n");
        exit(216);
	};
	hm=vm+Height;
	mgl=(BYTE*)(hm+Width);

// mgltmp=1 pour tous les points qui font partie du fond.
	tmp=gl; tmpstop=gl+Size; mgltmp=mgl; 
	while (tmp!=tmpstop)
	{
	    b=*(tmp++);
		*(mgltmp++)=((b!=255)?1:0);
		if (b==255) hole++;
    };

	for (k=0; k<2; k++) // minimum passer une fois sinon pas les bonnes valeurs dans hm et vm;
	{
		vmtmp=vm; sum=0; tmp=gl; tmpeol=gl+Width; tmpstop=gl+Size; W=0; mgltmp=mgl;
		while (tmp!=tmpstop) /* calcule la moyenne du fond sur toutes les lignes dans vm*/
		{
			if (tmp==tmpeol)
			{
				if (W!=0) *(vmtmp++)=sum/W; else *(vmtmp++)=maxDWORD;
				sum=0; W=0;
				tmpeol=tmp+Width;
			};
			if (*(mgltmp++)) { sum+=*tmp; W++; };
			tmp++;
		};
		if (W!=0) *vmtmp=sum/W; else *vmtmp=maxDWORD;

		vmtmp=hm; sum=0; tmp=gl; tmpeol=tmp+Size; tmpstop=gl+Size+Width-1;  i=0; H=0; mgltmp=mgl;
		while (tmp!=tmpstop) /* calcule la moyenne du fond sur toutes les colonnes dans hm*/
		{
			if (tmp==tmpeol)
			{
				if (H!=0) *(vmtmp++)=sum/H; else *(vmtmp++)=maxDWORD;
				sum=0; H=0;
				tmpeol++;
				tmp=gl+(++i); mgltmp=mgl+i;
			};
			if (*mgltmp) { sum+=*tmp; H++; };
			tmp+=Width; mgltmp+=Width;
		};
		if (H!=0) *vmtmp=sum/H; else *vmtmp=maxDWORD;

		tmp=gl; mgltmp=mgl; 
		for (i=0;i<Height; i++)
			for (j=0;j<Width; j++)
			{
				if (hm[j]==maxDWORD) { *(mgltmp++)=0; tmp++; continue; };
				if (vm[i]==maxDWORD) { *(mgltmp++)=0; tmp++; continue; };
				b=*(tmp++);
				if (b==255) { mgltmp++; continue; };
				*(mgltmp++)=(abs((int)(b-hm[j]*(1-ratio)-vm[i]*ratio))<=treshold?255:0);
			};
	};

	// calcule la valeur du "fond de secours" et la surface du dfaut.
	tmp=gl; tmpstop=gl+Size; mgltmp=mgl; sum=0; T=0;
	while (tmp!=tmpstop)
	{
	    // si le point courant appartient au fond alors bazar...
	    if (*(mgltmp++))
	    {
	        sum+=*tmp; T++;
	    };
	    tmp++;
	};
	secours=(BYTE)(sum/T);
	Surface=Size-T-hole;

	// calcule l'image finale re-centre en 128 avec rien au-dessus de 254 et le 
	// fond mis  128.
	tmp=gl; mgltmp=mgl;
	for (i=0;i<Height; i++)
		for (j=0;j<Width; j++)
		{
			if (*(mgltmp++)||(*tmp==255)) *(tmp++)=128;
			else 
			{
				if (hm[j]==maxDWORD)
				{ 
					if (vm[i]==maxDWORD) a=(int)(*tmp-secours)+128;
					else a=(int)(*tmp-vm[i])+128; 
				} else
				{
					if (vm[i]==maxDWORD) a=(int)(*tmp-hm[i])+128; 
					else a=(int)(*tmp-(hm[j]*(1-ratio)+vm[i]*ratio))+128;
				};
				if (a<0) a=0;
				if (a>=255) a=254;
				*(tmp++)=(BYTE)a;
			};
		};
	free(vm);
};

void image::filter(image *f, BYTE c, BYTE t)
{
	WORD i,j;
	DWORD incX,incY,counterY,counterX;
	BYTE *indexD,*indexS,*indexSstartline;	

	indexSstartline=f->gl;
	indexD=gl;
	incX=(DWORD)(65536*f->Width/Width);
	incY=(DWORD)(65536*f->Height/Height);
	if ((incX>65536)||(incY>65536)) 
	{
		printf("filter error"); exit(255);
	};
	counterY=0;
	for (j=0; j<Height; j++)
	{
		counterX=0;
		indexS=indexSstartline;
		for (i=0; i<Width; i++)
		{
			if (indexS[(int)(counterX>>16)]<t) (*indexD)=c;
			indexD++;
			counterX+=incX;
		};
		counterY+=incY;
		if (counterY>65535) 
		{
			indexSstartline+=f->Width;
			counterY&=65535;
		};
	};
};

void image::crop(BYTE c)
{
	BYTE *tmp=gl,*tmpeol=gl+Width,*tmpstop=gl+Size,*tmpS;	
	WORD i=0,j=Width-1;
	
	while (tmp!=tmpstop)    //enlever haut;
	{	
		if (tmp==tmpeol) { tmpeol+=Width; Height--; };
		if (*(tmp++)!=c) { Height++; tmp=tmpstop;}
	};
	Height--;
	if (Height==0) 
	{ 
	   gl=(BYTE*)realloc(gl,1); *gl=128; Size=1; Width=1; Height=1; return; 
	};
	tmpeol-=Width;
	memmove(gl,tmpeol,Size+(DWORD)(gl)-(DWORD)(tmpeol));
	
	tmp=gl+Width*Height-1; tmpeol=tmp-Width;
	while (tmp!=(gl-1))     //enlever bas;
	{	
		if (tmp==tmpeol) { tmpeol-=Width; Height--; };
		if (*(tmp--)!=c) { Height++; tmp=gl-1; };
	};	
	Height--;

	tmp=gl; tmpeol=gl+Size; tmpstop=gl+Size+Width-1;
	while (tmp!=tmpstop)   //bande de gauche
	{
		if (tmp==tmpeol) { tmpeol++; tmp=gl+(++i); }
		if (*tmp!=c) { tmp=tmpstop-Width; i--; }
		tmp+=Width;
	};
	i++;

	tmp=gl+j; tmpeol=gl+Size+j; tmpstop=gl+Size;
	while (tmp!=tmpstop)  // bande de droite
	{
		if (tmp==tmpeol) { tmpeol--; tmp=gl+(--j); }
		if (*tmp!=c) { tmp=tmpstop-Width; j++; }
		tmp+=Width;
	};
	j--;
	
	tmp=gl; tmpstop=gl+(j-i+1)*Height; tmpS=gl+i;
	while (tmp!=tmpstop) // enlever les bandes de gauche et de droite
	{
		memmove(tmp,tmpS,j-i+1);
		tmp+=j-i+1;
		tmpS+=Width;
	};

	Width=j-i+1;
	Size=Width*Height;
	gl=(BYTE*)realloc(gl,Size);
};

image::image(imageD *im, BYTE t): fgl(NULL), Width(im->Width), Height(im->Height), 
									Size(Width*Height)
{
	double *s=im->gl[1]+1,*d=s,*e=d+im->Size,a,max=128,min=-128,center,scale;
	BYTE *g;
	g=gl=(BYTE*)malloc(Size*sizeof(BYTE));
	if (gl==NULL)
	{
        fprintf(stderr,"img_convert_from_double: out of memory");
        exit(217);
	};

	if (t)
	{
		max=-INF;
		min=+INF;
		while (d!=e) { a=*(d++); max=MAX(a,max); }
		d=s;
		while (d!=e) { a=*(d++); min=MIN(a,min); }
	};
	center=(max+min)/2;
	scale=256/(max-min);

	while (s!=e)
	{ 
		a=(*(s++)-center)*scale+128;
		a=MAX(a,0);
		a=MIN(a,255);
		*(g++)=(BYTE)a;
	};
};

BYTE image::centerCrop(int _w,int _h)
{
	int i,w,h,htemp;
	BYTE *indexS,*indexD;

    if ((Width<=_w)&&(Height<=_h)) return 0;

    w=MIN(_w,Width);
    htemp=MAX(0,gravityH-_h/2);
	indexS=gl+MAX(0,gravityW-w/2)+htemp*Width;
	Height=h=MIN(Height-htemp,_h);
	
    indexD=gl;
	for (i=0; i<h; i++)
	{
  	    memcpy(indexD,indexS,w);
		indexD+=w;
		indexS+=Width;
	};
	Width=w;
	Size=h*w;
	gl=(BYTE*)realloc(gl,Size);
	if ((w==_w)&&(h==_h)) return 1;
	return 0;
};


BYTE image::pad(WORD w,WORD h,BYTE c)
{
	BYTE *indexS,*indexD,v=1;

	if ((w>Width)||(h>Height))
	{
		if ((w<Width)||(h<Height)) v=0;
		w=MAX(w,Width);
		h=MAX(h,Height);

		Size=w*h;
		gl=(BYTE*)realloc(gl,Size*sizeof(BYTE));

		if (w!=Width)
		{
			indexS=gl+Width*(Height-1); indexD=gl+w*(Height-1);
			while (indexS!=gl)
			{
				memmove(indexD,indexS,Width);
				memset(indexD+Width,c,w-Width);
				indexS-=Width;
				indexD-=w;
			}
			memmove(indexD,indexS,Width);
			memset(indexD+Width,c,w-Width);
		}
		if (h!=Height)
			memset(gl+w*Height,c,w*(h-Height));
		Width=w; Height=h;
		return v;
	};
	if ((w==Width)&&(h==Height)) return 1;
	return 0;
};

int LogOf2(int a)
{
    return (int)floor(log(a)/log(2)+1e-4);
};

int IsPowerOf2(WORD a)
{
    double hl=floor(log(a)/log(2)+1e-4);
	WORD h=(WORD)pow(2,hl);
	return (h==a);
};

void image::pad(BYTE c) // pad with color c so that height and width be a power of 2
{
    WORD h,w;
	if (IsPowerOf2(Height)) h=Height; else h=(WORD)pow(2,LogOf2(Height)+1);
	if (IsPowerOf2(Width )) w=Width;  else w=(WORD)pow(2,LogOf2(Width )+1);
	pad(w,h,c);
};

DWORD image::countHpeak(int treshold)
{
	BYTE *indexs=gl,*eoc=gl+Size,*index,state=0;
	DWORD sum, sumold=0, peak=0;

	while (indexs!=gl+Width)
	{
		index=indexs; 
		sum=0;
		while (index!=eoc) 
		{
			sum+=*index;
			index+=Width;
		};
		indexs++; eoc++;
		sum/=treshold*Height;

		if (sum>sumold) state=0;
		if (sum<sumold) 
		{
			if (state==0) peak++;
			state=1;
		}
		sumold=sum;
	};
	if (state==0) peak++;
	return peak;
};

DWORD image::countWpeak(int treshold)
{
	BYTE *eol=gl+Width,*index=gl,state=0;
	DWORD sum, sumold=0, peak=0;

	while (index!=gl+Size)
	{
		sum=0;
		while (index!=eol) sum+=*(index++);
		eol+=Width;
		sum/=treshold*Width;

		if (sum>sumold) state=0;
		if (sum<sumold) 
		{
			if (state==0) peak++;
			state=1;
		}
		sumold=sum;
	};
	if (state==0) peak++;
	return peak;
};

image::image(image *im, double ratio) : fgl(NULL)
// attention !!!  before using this function, you must initialize
// the two variables gravityW and gravityH bye calling analyse();
{
	WORD tl=im->gravityW+im->gravityH*im->Width,
		 lx=1,
		 ly=1,i;		 
	DWORD current=im->gl[tl],tmp,sum,sum2;
	BYTE *indexB,*indexE; // index_Begin; index_End
	char state,stateOld='t';

	while ((current<ratio*im->total)&&((lx!=Width)||(ly!=Height)))
	{
		state='u';
		tmp=im->Width*ly;
		// top
		sum=0;
		if (tl>=im->Width)
		{
			indexB=im->gl+tl-im->Width; indexE=indexB+lx;
			while (indexB!=indexE) 
				sum+=abs((int)(*(indexB++))-128);
			state='t';
		}
		// bottom
		sum2=0;
		if (tl<im->Size-tmp)
		{
			indexB=im->gl+tl+tmp; indexE=indexB+lx;
			while (indexB!=indexE) 
				sum2+=abs((int)*(indexB++)-128);
			if (sum2>sum) { sum=sum2; state='b'; };
		}
		// left
		sum2=0;
		if (tl % im->Width!=0)
		{
			indexB=im->gl+tl-1; indexE=indexB+tmp;
			while (indexB!=indexE) { sum2+=abs((int)*indexB-128); indexB+=im->Width; };
			if (sum2>sum) { sum=sum2; state='l'; };
		}
		// right
		sum2=0;
	 	if ((tl+lx) % im->Width!=0)
		{
			indexB=im->gl+tl+lx; indexE=indexB+tmp;
			while (indexB!=indexE) { sum2+=abs((int)*indexB-128); indexB+=im->Width; };
			if (sum2>sum) { sum=sum2; state='r'; };
		}
		
		if (sum==0)
		{
			do
			{
				if (stateOld=='t') state='b';
				if (stateOld=='b') state='l';
				if (stateOld=='l') state='r';
				if (stateOld=='r') state='t';
				stateOld=state;
			} while (!(((state=='t')&&(tl>=im->Width)         )||
		               ((state=='b')&&(tl<im->Size-tmp)       )||
		 		       ((state=='l')&&(tl % im->Width!=0)     )||
					   ((state=='r')&&((tl+lx) % im->Width!=0))
					  )
					);
		};

		switch (state)
		{
		case 'u': printf("extraction error"); 
				  exit(255);
		case 't': tl-=im->Width; 
		case 'b': ly++; break;
		case 'l': tl--;
		case 'r': lx++; break;
		};
		current+=sum; stateOld=state;
	};
    Width=lx;
    Height=ly;
	Size=lx*ly;
	indexE=gl=(BYTE*)malloc(Size*sizeof(BYTE));
	if (gl==NULL)
	{
        fprintf(stderr,"img_cut: out of memory.\n"); exit(218);
	};
	indexB=im->gl+tl;
	for (i=0; i<ly; i++)
	{
		memcpy(indexE,indexB,lx*sizeof(BYTE));
		indexE+=lx;
		indexB+=im->Width;
	};
};

DWORD image::countRpeak(int treshold, WORD x, WORD y)
{
	DWORD sum, sumold=0, peak=0;
	char state=0;

	BYTE *indexS=gl+x+y*Width,*indexB,*indexE;
	WORD lx=1,ly=Width,nStep,j;

	nStep=MIN(MIN(x,y),MIN(Width-x,Height-y));

	for (j=0; j<nStep; j++)
	{
		sum=0;

		// decomposition en [=]
		// partie -
			indexB=indexS; indexE=indexB+lx;
			while (indexB!=indexE) sum+=*(indexB++);
			
		// partie _
			indexB=indexS+ly-Width; indexE=indexB+lx;
			while (indexB!=indexE) sum+=*(indexB++);
			
		// partie [
			indexB=indexS; indexE=indexB+ly;
			while (indexB!=indexE)
			{
				sum+=*indexB;
				indexB+=Width;
			};
		// partie ]
			indexB=indexS+lx-1; indexE=indexB+ly;
			while (indexB!=indexE)
			{
				sum+=*indexB;
				indexB+=Width;
			};
		// final:
		indexS-=(Width+1);
		lx+=2;
		ly+=(Width<<1);

		sum/=(lx<<2)*treshold;

		if (sum>sumold) state=0;
		if (sum<sumold) 
		{
			if (state==0) peak++;
			state=1;
		}
		sumold=sum;
	};
	if (state==0) peak++;

	return peak;
};

DWORD image::countApeak(int treshold, int portions, WORD x, WORD y)
{
	BYTE **EOL=(BYTE**)malloc((MAX(Height-y,y)+2)*sizeof(BYTE**)),**indexEOL,*inter;
	BYTE *angularMap=(BYTE*)malloc(Size),*start=angularMap+y*Width,*startL,*indexB,*indexE,a;
	DWORD *surface=(DWORD*)malloc((2*portions+1)*sizeof(DWORD)),
		  *gray=surface+portions,peak=0;
	double incAngle=2*PI/portions,angle=incAngle,cas_limite,sum,sumold=0;
	long incX,xp;
	int i,j;
	char state=0;

    if ((angularMap==NULL)||(EOL==NULL)||(surface==NULL))
    {
        fprintf(stderr,"img_countApeak: out of memory"); exit(219);
    };

    if (x==0)
    {
        free(angularMap); free(surface); free(EOL); return 0;
    };
    
    cas_limite=PI-atan(1/x);    
	i=0;

	*EOL=angularMap+Width*(y+1); indexEOL=EOL;
	for (j=0; j<y; j++) 
	{ 
	   inter=*indexEOL-Width;
	   *(++indexEOL)=inter;	   
	};
	while (cas_limite-angle>1e-10)
	{
		indexEOL=EOL;
		xp=x<<16;
		startL=start; indexB=startL+x;
		incX=(long)(65536/tan(angle));
		while ((startL>=angularMap)&&((xp>>16)<Width))
		{
			indexE=*indexEOL; *(indexEOL++)=indexB;
			while (indexB!=indexE) *(indexB++)=i;

			startL-=Width;
			xp+=incX;
			if (xp<0) 
			{ 
				if (*indexEOL==startL) break;
				indexB=startL; 
			}
			else indexB=startL+(xp>>16);
		};
		angle+=incAngle;
		i++;
	};

	startL=start; indexEOL=EOL;
	while (startL>angularMap)
	{
		indexB=startL; indexE=*(indexEOL++);
		while (indexB!=indexE) *(indexB++)=i;
		startL-=Width;
		if (*indexEOL==startL) break;
	};
	
	while (angle<=PI+1e-6) 
	{
		i++; 
		angle+=incAngle; 
	};

	cas_limite=2*PI-atan(1/(Width-x));

    *EOL=angularMap+Width*(y+1)-1; indexEOL=EOL;
	for (j=0; j<(Height-y)-1; j++) 
    { 
	   inter=*indexEOL+Width;
	   *(++indexEOL)=inter;
	};

	while (cas_limite-angle>1e-10)
	{		
		indexEOL=EOL;
		xp=x<<16;
		startL=start+Width; indexB=startL+x;
		incX=(long)(-65536/tan(angle));
		while ((startL<angularMap+Size)&&(xp>0))
		{
			indexE=*indexEOL; 
			*(indexEOL++)=indexB;
			while (indexB!=indexE) *(indexB--)=i;

			startL+=Width;
			xp+=incX;
			if ((xp>>16)>=Width) 
			{ 
				if (*indexEOL==startL+Width-1) break;
				indexB=startL+Width-1; 
			}
			else indexB=startL+(xp>>16);
		};
		angle+=incAngle;
		i++;
	};

	startL=start+(Width<<1)-1; indexEOL=EOL;
	while (startL<angularMap+Size)
	{
		indexB=startL; indexE=*(indexEOL++);
		while (indexB!=indexE) *(indexB--)=i;
		startL+=Width;
		if (*indexEOL==startL) break;
	};

	free(EOL);

//	memcpy(gl,angularMap,Size); // debug instruction

	memset(surface,0,(2*portions+1)*sizeof(DWORD));	

	indexB=angularMap; indexE=angularMap+Size;
	while (indexB!=indexE)
	{
		a=*(indexB++);
		surface[a]++;
		gray[a]+=a;
	}
	free(angularMap);

	for (j=0; j<portions; j++)
	{
		if (surface[j]==0) continue;
		sum=gray[j]/((double)(treshold*surface[j]));

		if (sum>sumold) state=0;
		if (sum<sumold) 
		{
			if (state==0) peak++;
			state=1;
		}
		sumold=sum;
	};
	if (state==0) peak++;

	free(surface); 
	return peak;
};

void image::process(double ratio,BYTE treshold,double anti_treshold_ratio,
				double scaleX,double scaleY)
{
	WORD x,y;
	BYTE anti_treshold; 
	image *im5;

	imCeil(ratio,treshold);
	save("inter0.bmp");
	im5=new image(this,scaleX,scaleY);
	im5->find_max(&x,&y);
	anti_treshold=MAX((BYTE)(ABS(im5->gl[x+y*im5->Width]-128)*anti_treshold_ratio),1);
	im5->flood_fill(x,y,anti_treshold);
	im5->save("inter1.bmp");
	filter(im5,128,255);
	delete im5;
	crop(128);
};
