/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 ***************************************/

#ifndef __INCLUDE_C45GEN__
#define __INCLUDE_C45GEN__

#include "definitions.h"
#include <limits.h>

typedef  int  ItemNo;
typedef  double ItemCount;

#define ItemCount_MAX DOUBLE_MAX

struct Node_Tag
     {
        short    NodeType;    /* 0=leaf 1=branch 2=cut 3=subset */
        ClassNo   Leaf;        /* most frequent class at this node */
        ItemCount   Items,        /* no of items at this node */
					*ClassDist;    /* class distribution of items */
        double   Errors;        /* no of errors at this node */
        Attribute  Tested;     /* attribute referenced in test */

        double Confidence;
  
        //      short    Forks;        /* number of branches at this node */
        double    Cut;        /* threshold for continuous attribute */
        struct Node_Tag *lower,*upper; /* Branch[x] = (sub)tree for outcome x */
	};
typedef struct Node_Tag Node;

#define  Unknown  -999        /* unknown value for continuous attribute */
#define  None     -1		  /* no split */
#define  Epsilon  1E-3
#define  LeafType 0
#define  ThreshContin 2    /*        threshold cut */

//#define     Log2            0.69314718055994530942
#define     Log(x)            ((x) <= 0 ? 0.0 : log((double)x) / 0.69314718055994530942)

#endif
