/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 ***************************************/

#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include <math.h>
#include "textUtils.h"


#define TINY 1.0e-20

void ludcmp(double **a, int n, int *indx, double *d)
{
	int i,imax,j,k;
	double big,dum,sum,temp;
	double *vv=(double*)malloc(n*sizeof(double));
	*d=1.0;
	for (i=0;i<n;i++) 
	{
		big=0.0;
		for (j=0;j<n;j++)
			if ((temp=fabs(a[i][j])) > big) big=temp;
		if (big == 0.0) printf("Singular matrix in routine ludcmp");
		vv[i]=1.0/big;
	}
	for (j=0;j<n;j++) 
	{
		for (i=0;i<j;i++)
		{
			sum=a[i][j];
			for (k=0;k<i;k++) sum -= a[i][k]*a[k][j];
			a[i][j]=sum;
		};
		big=0.0;
		for (i=j;i<n;i++)
		{
			sum=a[i][j];
			for (k=0;k<j;k++)
				sum -= a[i][k]*a[k][j];
			a[i][j]=sum;
			if ( (dum=vv[i]*fabs(sum)) >= big) 
			{
				big=dum;
				imax=i;
			}
		}
		if (j != imax) 
		{
			for (k=0;k<n;k++) 
			{
				dum=a[imax][k];
				a[imax][k]=a[j][k];
				a[j][k]=dum;
			}
			*d = -(*d);
			vv[imax]=vv[j];
		}
		indx[j]=imax;

		if (a[j][j] == 0.0) a[j][j]=TINY;
		if (j != n-1) 
		{
			dum=1.0/(a[j][j]);
			for (i=j+1;i<n;i++) a[i][j] *= dum;
		}
	}
	free(vv);
};


void lubksb(double **a, int n, int *indx, double *b)
{
	int i,ii=-1,ip,j;
	double sum;
	for (i=0;i<n;i++) 
	{
		ip=indx[i];
		sum=b[ip];
		b[ip]=b[i];
		if (ii>=0)
			for (j=ii;j<i;j++) sum -= a[i][j]*b[j];
		else if (sum) ii=i;
		b[i]=sum;
	}
	for (i=n-1;i>=0;i--) 
	{
		sum=b[i];
		for (j=i+1;j<n;j++) sum -= a[i][j]*b[j];
		b[i]=sum/a[i][i];
	}
}

void solve(double *_a,double *b,int n)
{
	double d,**a=(double**)malloc(n*sizeof(double*));
	int i,*indx=(int*)malloc(n*sizeof(int));
	for (i=0; i<n; i++) { a[i]=_a; _a+=n; };
	ludcmp(a,n,indx,&d);
	lubksb(a,n,indx,b);
	free(indx); free(*a); free(a); 
		//the original matrix a is detroyed (and replaced by a LU decomposition)
		//that's why it's free from memory.
};

/*
double *inverse(double *_a, int n)
{
	double d,**a=(double**)malloc(n*sizeof(double*)),
		   *y=(double*)malloc(n*n*sizeof(double)),
		   *col=(double*)malloc(n*sizeof(double));
	int i,j,*indx=(int*)malloc(n*sizeof(int));
	for (i=0; i<n; i++) { a[i]=_a; _a+=n; };

	ludcmp(a,n,indx,&d);
	for(j=0;j<=n;j++)
	{
		for(i=0;i<=n;i++) col[i]=0.0;
		col[j]=1.0;
		lubksb(a,n,indx,col);
		for(i=0;i<=n;i++) y[i*n+j]=col[i];
	};
	free(indx); free(*a); free(a); free(col);
	return y;
};

double determinant(double *_a, int n)
{
	double d,**a=(double**)malloc(n*sizeof(double*));
	int i,*indx=(int*)malloc(n*sizeof(int));
	for (i=0; i<n; i++) { a[i]=_a; _a+=n; };
	ludcmp(a,n,indx,&d);
	for(i=0;i<n;i++) d*=a[i][i];
	free(indx); free(*a); free(a); 
	return d;
};
*/
void init_params(char *filename, double **_a, double **_b, int *_n)
{	
    FILE *stream;
    char line[300],*tline;
	int i=0,j,k;
	double *a,*b;
	int n;

    if ((stream=fopen(filename,"r"))==NULL) 
    {
        printf("Data file not found.\n"); exit(1);
    };

	while ((fgets(line,300,stream)!=NULL))
	{
		if (emptyline(line)) continue;
		switch (i)
		{
			case 0: *_n=n=lire_Number_of_Attributes(line);
			        *_a=a=(double*)malloc(n*n*sizeof(double));
			        *_b=b=(double*)malloc(n*n*sizeof(double));
			        tline=line; 
			        for (j=0; j<n; j++) 
			            b[j]=lire_double(&tline);
			        break;
			case 1: for (k=0; k<n; k++)
			        {
			            tline=line; 
			            for (j=0; j<n; j++) 
			            // the good line (of the 2 below) is the first
			                a[k*n+j]=lire_double(&tline);
			            //    a[k+j*n]=lire_double(&tline);
			            if (k<n-1) fgets(line,300,stream);
			        };
			        break;
        };
        i++;
	};
};

int main(int argc, char **argv)
{
    double *a,*b;
    double tot=0;
    int n,i;
    FILE *f;
    
	if (argc!=2)
	{
		printf("SYNTAX: kc_comp <data_file>\n\n"
		       "You build classifier based on a trusted training set. After, you use\n"
		       "this classifier on a unknown set. The classifier gives you back a class\n"
		       "distribution.\n\n"
			   "The goal of this program is to correct the class distribution on the\n"
			   "unknown set using information contained in the confusion matrix build on\n"
			   "the trusted training set.\n\n"
			   "The data_file is an ASCII file that contains the class distribution to\n"
			   "correct (on the first line) and the confusion matrix. The output of the\n"
			   "program is a file 'distribution.txt' which contains the corrected\n"
			   "distribution.\n");
		exit(255);
	};

    init_params(argv[1],&a,&b,&n);

    for (i=0; i<n*n; i++) tot+=a[i];
    for (i=0; i<n*n; i++) a[i]/=tot;
/*    
    tot=0;
    for (i=0; i<n; i++) tot+=b[i];
    for (i=0; i<n; i++) b[i]/=tot;
*/
	solve(a,b,n);

    f=fopen("distribution.txt","w");
    for (i=0; i<n; i++) fprintf(f,"%8.2f",b[i]);
    fprintf(f,"\n");
    fclose(f);

    printf("'distribution.txt' written on the disk.\n");
	return 0;
};
