/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 ***************************************/

#include <stdlib.h>
#include <stdio.h>

#define EOL1 13
#define EOL2 10

char emptyline(char *line)
{
	int i=0;
	if (line[0]==';') return 1;
	while (line[i]==' ') i++;
	if ((line[i]==EOL1)||(line[i]==EOL2)||(line[i]=='\0')) return 1;
	return 0;
};

double lire_double(char **line)
{
	char *tline=*line,*oldtline;

	while(*tline==' ') tline++;
	oldtline=tline;
	while(((*tline>='0')&&(*tline<='9'))||
		  (*tline=='.')||
		  (*tline=='e')||
		  (*tline=='+')||
		  (*tline=='-')) tline++;
	if (oldtline==tline)
	{
		*line=NULL; return 0;
	};
	*tline='\0';
	(*line)=tline+1;
	return atof(oldtline);
};

int lire_Number_of_Attributes(char *line)
{
	char *tline=line; 
	int n;

	n=0;
	while ((*tline!=EOL1)&&(*tline!=EOL2))
	{
		while ((*tline==' ')|| 
			   (*tline=='\t'))tline++;
		if ((*tline==EOL1)||(*tline==EOL2)) break;
		while(((*tline>='0')&&(*tline<='9'))||
	  		  (*tline=='.')||
			  (*tline=='e')||
			  (*tline=='+')||
			  (*tline=='-')) tline++;
		n++;
	};
	return n;
};

char *GetRidOfTheEOL(char *tline)
{
   char *t=tline;
   while (*t==' ') t++;
   while ((*tline!=EOL1)&&(*tline!=EOL2)&&(*tline!=' ')&&(*tline)) tline++;
   *tline='\0';
   return t;
};

void lire_Vdouble(char *line,double **d, int *n)
{
	char *tline=line; 
	int k;

	*n=lire_Number_of_Attributes(line);
	if (*n==0) { *d=NULL; return; };
	*d=(double*)calloc(*n,sizeof(double));
	tline=line; 
	for (k=0; k<(*n); k++) (*d)[k]=lire_double(&tline);
};


#ifdef __INSIDE_GVB_SERVER__

#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>

unsigned long lireIP(char *tline)
{
    struct hostent *hp;
    GetRidOfTheEOL(tline);
    if ((hp=gethostbyname(tline))==NULL)
    {
        fprintf(stderr,"machine %s inconnue.\n",tline);
        exit(2); 
    };
    return *((unsigned long*)(hp->h_addr));
    
/*  // old version
    int j; unsigned long A=0; char *ol=tline;
	for (j=0; j<4; j++)
	{
	   while ((*tline>='0')&&(*tline<='9')) tline++;
	   *tline='\0'; A=(A<<8)+atol(ol); tline++; ol=tline;
	};
	return htonl(A); */
};

typedef unsigned char BYTE;
void ecrireIP(unsigned long ip)
{
    unsigned long a=ntohl(ip);
    fprintf(stderr,"%i.%i.%i.%i",(BYTE)(a>>24),(BYTE)(a>>16)&255,(BYTE)(a>>8)&255,(BYTE)a&255);
};

#endif
