/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 ***************************************/

#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include "classifier.h"
#include "DataSet.h"

int main(int argc, char **argv)
{
	Classifier *c;
	DataSet *AllItem;

	if (argc<3)
	{
		printf("SYNTAX: kc_validate <DataSet_file> <Classifier_file> [<confusion_matrix_file>]\n\n"
			   "The goal of this program is to test the classification accuracy of\n"
			   "<Classifier_file> on the <DataSet_file>. The program will generate\n"
			   "the <confusion_matrix_file> which contains the resulting confusion\n"
			   "matrix. If <confusion_matrix_file> is omitted the program will use\n"
			   "'confusion_matrixV.txt'.\n");
		exit(255);
	};

	AllItem=new DataSet(argv[1]);
    printf("\nRead %d cases (%d attributes)\n",AllItem->nItem, AllItem->MaxAtt);
	c=NewClassifier(argv[2]);

	if (argc>=4)
	    c->createAndSaveConfMatrix(AllItem,argv[3]);
	else 
    	c->createAndSaveConfMatrix(AllItem,"confusion_matrixV.txt");

	// printf("press a key.\n"); getchar();
	return 0;
};
