/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 ***************************************/

#ifndef __INCLUDE_DATASET__
#define __INCLUDE_DATASET__

#include "C45.h"

// #define ClassTest(Case) (*((ClassNo*)(DataSet.Item[Case]+MaxAtt)))

#ifdef __NO_DATASET__
#define __EVAL_ONLY__
#else

class DataSet
{
public:
	double **Item;
	int nItem, iw;
	Attribute MaxAtt;
	ClassNo	 MaxClass,MinClass;
	double OldCrossValTot;

	DataSet();
	DataSet(char *filename, int w=0);
	~DataSet();
	
	DataSet *generate_Create_Set(int p, double CrossValTot);
	DataSet *generate_Test_Set(int p, double CrossValTot);
	DataSet *generate_Bootstrap();
    DataSet *generate_Binary_Set(ClassNo c1, ClassNo c2);
    void save(FILE *f);

private:
// the following variable is only used to free up memory space
// used by the items
	double *StartOfItemSpace1;
    void equilibrate(double);
};

#endif

#ifdef __inside_datasetcpp__
char countBits[256] =
{
    0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, /* 0- 15 */
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, /* 16 - 31 */
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, /* 32 - 47 */
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, /* 48 - 63 */
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, /* 64 - 79 */
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, /* 80 - 95 */
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, /* 96 - 111 */
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, /* 112 - 127 */
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, /* 128 - 143 */
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, /* 144 - 159 */
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, /* 160 - 175 */
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, /* 176 - 191 */
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, /* 192 - 207 */
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, /* 208 - 223 */
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, /* 224 - 239 */
    4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8  /* 240 - 255 */
};
#else
extern char countBits[];
#endif

class BinaryDataSet
{
  private:
    void initMemory();

  public:
    BinaryDataSet(FILE *f);
    ~BinaryDataSet();
    unsigned char *d,endChar;
    ClassNo *c;
    int *o;
    int nAtt,nExample, nItem, lineSize;

    inline int distance(unsigned char *c1,unsigned char *c2)
    {
        int ls=lineSize-1, n=0;
        while (ls--) n+=countBits[(*(c1++)) ^ (*(c2++))];            

//        {
//            cc=(*(c1++)) ^ (*(c2++));
//            if (cc&1) n++;
//            if (cc&2) n++;
//            if (cc&4) n++;
//            if (cc&8) n++;
//            if (cc&16) n++;
//            if (cc&32) n++;
//            if (cc&64) n++;
//            if (cc&128) n++;
//        }

        n+=countBits[((*c1) ^ (*c2)) & endChar];
        return n;
    }

#ifndef __EVAL_ONLY__

    BinaryDataSet(DataSet *D);
    void save(FILE *f);
    void add(unsigned char *nd, ClassNo c);
    inline int equals(unsigned char *c1,unsigned char *c2)
    {
        int ls=lineSize-1;
        if (memcmp(c1,c2,ls)!=0) return 0;
        c1+=ls; c2+=ls;
        if (((*c1) ^ (*c2))& endChar) return 0;
        return 1;
    }

#endif

};

#endif
