/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 * *************************************/

#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include "classifier.h"
#include "DataSet.h"
#include "textUtils.h"

#define LINELENGTH 10000

int main(int argc, char **argv)
{
    char line[LINELENGTH],*tline;
	double *f,confidence;
	ClassNo rep;
	int i,j=1;
	Classifier *c;
	DataSet *AllItem;

    if (argc!=3)
	{
		printf("SYNTAX: kc_ask2 <DataSet_file> <Classifier_file>\n\n"
			   "The goal of this program is to test the classification accuracy\n"
			   "of <Classifier_file> on the <DataSet_file>.\n"
			   "The program will generate a file new 'DSfile.txt' which\n"
			   "contains classes predicted by the Classifier.\n");
		exit(255);
	};

	AllItem=new DataSet(argv[1]);
    printf("\nRead %d cases (%d attributes)\n",AllItem->nItem, AllItem->MaxAtt);
	c=NewClassifier(argv[2]);

    FILE *stream=fopen(argv[1],"r");
    FILE *F2=fopen("DS_experimental_tree_results.txt","w");
	for (i=0; i<AllItem->nItem; i++)
	{
		rep=c->eval(AllItem->Item[i],&confidence);
		while ((fgets(line,LINELENGTH,stream)!=NULL)&&(emptyline(line)));
		tline=line;  while (*tline!=' ') tline++; tline++; *tline='\0';
		fprintf(F2,line);
		f=AllItem->Item[i];
        for (j=0; j<AllItem->MaxAtt; j++) fprintf(F2,"%e ",f[j]);
        fprintf(F2,"%i %f\n",rep,confidence);
	};
    fclose(F2); fclose(stream);

	return 0;
};
