import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Tron extends javax.swing.JFrame
                  implements ActionListener, KeyListener, MouseListener
{
    private JButton jButton1;
    private JPanel jPanel2;

    Timer timer;
    int dx1,dy1,dx2,dy2,x1,y1,x2,y2;
    boolean grille[][];

    /** Creates new form Tron */
    public Tron() {
        Container c=getContentPane();

        this.addKeyListener(this);
        
        addWindowListener (new java.awt.event.WindowAdapter () {
            public void windowClosing (java.awt.event.WindowEvent evt) {
	        System.exit (0);
            }
        });
        
        jButton1=new JButton ("Start");
        jButton1.addMouseListener (this);
        jButton1.addKeyListener(this);
        c.add(jButton1, java.awt.BorderLayout.WEST);

        JButton jButton2=new JButton ("Stop");
        jButton2.addMouseListener (this);
        jButton2.addKeyListener(this);
        c.add(jButton2, java.awt.BorderLayout.EAST);

        jPanel2=new JPanel();
        jPanel2.setPreferredSize (new java.awt.Dimension(300, 300));
        jPanel2.setBorder (new javax.swing.border.LineBorder(java.awt.Color.black));
        jPanel2.setMinimumSize (new java.awt.Dimension(300, 300));
        c.add (jPanel2, java.awt.BorderLayout.SOUTH);

        pack();
        timer = new Timer(10, this);
        timer.setCoalesce(true);
        grille=new boolean[300][300];
        stopGame();
        for (int i=0; i<300; i++)
        {
            grille[i][0]=true;
            grille[0][i]=true;
            grille[299][i]=true;
            grille[i][299]=true;
        };
    }
 
    private void stopGame()
    {
        if (timer.isRunning()) timer.stop();
        jPanel2.repaint();
        for (int i=1; i<299; i++)
           for(int j=1; j<299; j++)
               grille[i][j]=false;
    }

    private void startGame() {
        if (!timer.isRunning()) 
        {
           x1=100; y1=150; dx1=1;  dy1=0;
           x2=200; y2=150; dx2=-1; dy2=0;
           timer.start();
        };
    }

    public void mouseClicked(java.awt.event.MouseEvent mouseEvent) {
        if (mouseEvent.getSource()==jButton1) startGame();
        else stopGame();
    }

    public void keyPressed(java.awt.event.KeyEvent evt) 
    {
        int a=evt.getKeyCode();
        switch(a)
        {
            case KeyEvent.VK_LEFT:  dx1=-1; dy1=0;  break;
            case KeyEvent.VK_RIGHT: dx1=1;  dy1=0;  break;
            case KeyEvent.VK_UP:    dx1=0;  dy1=-1; break;
            case KeyEvent.VK_DOWN:  dx1=0;  dy1=1;  break;
            case KeyEvent.VK_Q: dx2=-1; dy2=0;  break;
            case KeyEvent.VK_D: dx2=1;  dy2=0;  break;
            case KeyEvent.VK_Z: dx2=0;  dy2=-1; break;
            case KeyEvent.VK_S: dx2=0;  dy2=1;  break;
        }
    }

    public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
        //Advance the animation frame.
        Graphics g=jPanel2.getGraphics();
        
        if (grille[x1][y1]&&grille[x2][y2])
        {
            JOptionPane.showMessageDialog(null, "It's a draw.");            
            stopGame();
            return;
        };
        if (grille[x1][y1]) 
        {
            JOptionPane.showMessageDialog(null, "Blue wins.");
            stopGame();
            return;
        };
        if (grille[x2][y2]) 
        {
            JOptionPane.showMessageDialog(null, "Red wins.");
            stopGame();
            return;
        };
        g.setColor(Color.red);
        g.fillRect(x1,y1,1,1);
        g.setColor(Color.blue);
        g.fillRect(x2,y2,1,1);
        grille[x1][y1]=true;
        grille[x2][y2]=true;
        x1+=dx1; y1+=dy1;
        x2+=dx2; y2+=dy2;
    }
    
    public static void main (String args[]) {
        new Tron ().show ();
    }
    
    
    public void mousePressed(java.awt.event.MouseEvent mouseEvent) {}
    public void mouseEntered(java.awt.event.MouseEvent mouseEvent) {}
    public void mouseExited(java.awt.event.MouseEvent mouseEvent) {}    
    public void mouseReleased(java.awt.event.MouseEvent mouseEvent) {}
    public void keyReleased(java.awt.event.KeyEvent keyEvent) {}    
    public void keyTyped(java.awt.event.KeyEvent keyEvent) {}
    
}