#ifndef __INCLUDE_KEEPBEST__
#define __INCLUDE_KEEPBEST__

#define INF 1.7E+308 

typedef struct cell_tag
    {
        double K;
        double value;
        double *optValue;
        struct cell_tag *prev;
    } cell;

class KeepBests
{
public:
    KeepBests(int n);
    KeepBests(int n, int optionalN);
    void setOptionalN(int optinalN);
    ~KeepBests();
    void reset();
    void add(double key, double value);
    void add(double key, double value, double optionalValue);
    void add(double key, double value, double *optionalValue);
    void add(double key, double value, double *optionalValue, int nn);
    double getKey(int i);
    double getValue(int i);
    double getOptValue(int i, int n);
    double* getOptValue(int i);
private:
    void init();
    cell *ctable,*end,*_local_getOptValueC;
    int n,optionalN,_local_getOptValueI;
};

#endif
