#ifndef __INCLUDE_LAZY__
#define __INCLUDE_LAZY__

typedef unsigned char BOOL;
#define INF 1.7E+308 
#define MMAX(a,b) ((a)>(b)?(a):(b))
#define MMIN(a,b) ((a)<(b)?(a):(b))
#define TRUE 1
#define FALSE 0

#include "mathutil.h"
#include "KeepBests.h"

class Lazy
{
  public:
    Lazy(Table *_X, VectorI *range);
    ~Lazy();
    BOOL setKernel(VectorI *range);
    VectorI *getKernel();
    void setValM(long _val0,long _val1,long _val2);
    void unsetValM();
    void setWvec(double *_Wvec);
    void unsetWvec();
    BOOL setComb(VectorI *v);
    BOOL setComb(int c);
    VectorI *getComb();
    void setLAMBDA(double _LAMBDA);
    void unsetLAMBDA();
    void eval(double *Q,double *y_hat, double **t_hat, double *errorP);
    BOOL tableHasChanged();
    void setDistanceCheck(BOOL (*g)(double *,int));
    void unsetDistanceCheck();
    
  private:

    BOOL checkAndAllocateMemory();
    void freeStuff();

    Table *X;    
    int idm0,  idM0,  idm1,  idM1,  idm2,  idM2,  cb0,  cb1,  cb2,  cbA,
        idm0a, idM0a, idm1a, idM1a, idm2a, idM2a, acb0, acb1, acb2, acbA,
        val0, val1, val2, noBestDistIndx, maxNZ, Go0, Go1, Go2;
    double LAMBDA, *C,*Wvec, **Z1, **Z2, *W, *BestDist, **v1,*t1,*a1,**v2,*t2,*a2,*t;
    KeepBests *bestPoints, *BestA, *Best0, *Best1, *Best2;
    BOOL (*g)(double *,int);
};

#endif
