function [output,error] = NLConstr_Fletcher(isGradNeeded,j,x)
error=0;
if isGradNeeded == 0,
	% simple evaluation 
	switch j
   case 1 
      output = 1-x(1)*x(1)-x(2)*x(2);
   case 2
      output = x(2)-x(1)*x(1);
   end
else
   % gradient computation
	switch j
   case 1 
      output(1) = -2*x(1);
      output(2) = -2*x(2);
   case 2
      output(1) = -2*x(1);
      output(2) = 1;
   end   
end
