function report = postmining(pred,testset)
%POSTMINING compute the confusion matrix and error rates
%    between supervision and prediction
%    
%     compute confusion matrices, error rates and Kappa
%    between supervision and prediction
%    
%    with the arguments below :
%    PRED :	prediction vector [].
%    TESTSET : supervision dataset object.
%    and returns:
%    REPORT : a structure containing global and class by class
%    error rates, Kappa and confusion matrix.
%    
%    See also: CONFMAT 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	compute the confusion matrix and error rates between supervision and prediction
%
%   @synopsys	report=postmining(pred,testset)
%   @description  compute confusion matrices, error rates and Kappa between supervision and prediction<br>
%<br>
%    with the arguments below :<br>
%    <code>pred</code> :	prediction vector [].<br>
%    <code>testset</code> : supervision dataset object.<br>
%    and returns:<br>
%    <code>report</code> : a structure containing global and class by class error rates, Kappa and confusion matrix.
%   @see confmat 
%
%MAN_PAGE_END

% Olivier Debeir (c) 1999
% Written : summer 1999

sup=get(testset,'classes');
%m=length(sup);
m=get(testset,'ns');
%nc=max(max(sup),max(pred));
nc=get(testset,'nc');
M=zeros(nc,nc);
missed=[];
for i = 1:m
   M(sup(i),pred(i))= M(sup(i),pred(i)) +1;
   if sup(i)~=pred(i)
      missed=[missed;i];
   end  
end

D  = sum(M.*eye(nc,nc));
ni = sum(M');

Drel = D./ni;

overall_acc=trace(M)/sum(sum(M));
average_acc=sum(Drel)/nc; %%% == mean(Drel);
numKi = zeros(1,nc);
denomKi = zeros(1,nc);
for i=1:nc
   numKi(i)   = sum(sum(M)) * D(i) - sum(M(i,:)) * sum(M(:,i));
   denomKi(i) = sum(sum(M)) * sum(M(i,:)) - sum(M(i,:)) * sum(M(:,i));
end
Kappai = numKi ./ denomKi;
Kappa  = sum(numKi)/sum(denomKi) ;

Mrel = M./ repmat(ni',1,nc);

report.M    = M;
report.Mrel = Mrel;
report.Average_acc = average_acc;
report.Overall_acc = overall_acc; %%% global good classification rate
report.D    = D;
report.Drel = Drel;
report.Kappai = Kappai;
report.Kappa  = Kappa;
report.missed = missed;

