function out=subsref(d,s)
%SUBSREF overload the subscript reference operator
%    
%    FUNCTION OUT=SUBSREF(D,S) subsref(d,s) will return either
%    a sub-datatset or a part of the dataset object depending
%    on the subscript method. D is the data set and S is the
%    reference specification structure.
%    
%    See also: ALSO SUBSREF
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	overload the subscript reference operator
%
%   @synopsis	function out=subsref(d,s)
%   @description	subsref(d,s) will return either a sub-datatset or a part of
%	the dataset object depending on the subscript method. <code>d</code> is the
%	data set and <code>s</code> is the reference specification structure.
%
%   @see also <code>subsref</code>
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 18/03/99

loadfromdisk(d);

if s(1).type=='()',
	sn = size(d,2);
	
	% Extract the references that are linked to the numerical data
	subs = s(1).subs{2};
	if (subs == ':'),
		subs = 1:sn;
	end
	%*** I am not sure of these lines -- Antoine
	classcol = find(strcmp(d.vartypes,'class'));
	if ~isempty(classcol),
		if all(subs ~= classcol),
			subs = [subs(:);classcol]'; 
		end
	end
	
	tref=struct('type','()');
	
	s(1).subs{2} = subs;
	tref.subs = {':' subs};
	
	if ~isempty(subs),
		data=subsref(d.data,s(1));
		variables=subsref(d.variables,tref);
		vartypes=subsref(d.vartypes,tref);
		symbols=subsref(d.symbols,tref);
	else
		data = [];
		features = {};
		vartypes={};
		symbols={};
	end
	
	tref.subs={s(1).subs{1} ':'};
	labels=subsref(d.labels,tref);
	
	out=dataset(data,'symbols',symbols,'vartypes',vartypes,'labels',labels,'variables',variables);

elseif s(1).type=='.',
	out=get(d, s(1).subs);
end

if (size(s,2)>1),
	out=subsref(out,s(2:end));
end

