function m=add_statemapping(m,themap)
%ADD_STATEMAPPING add a mapping for describing the state
%    of an internal object
%    
%    This method adds a mapping to the list of the current
%    mappings attached to the state of the internal object.
%    The links field, which connects the mapping with the
%    state output, must be set using the SET method. 
%    
%    M=ADD_STATEMAPPING(M) clears the statemapping field of
%    the object
%    
%    M=ADD_STATEMAPPING(M,{MAPPING}) adds the mapping MAPPING
%    to the current mapping state description.  
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose add a mapping for describing the state of an internal object.
%	This method adds a mapping to
%   the list of the current mappings attached to the state of the internal object. The links
%   field, which connects the mapping with the state output, must be set using
%   the <code>set</code> method. 
%
%   @synopsis   m=add_statemapping(m)
%   @description clears the statemapping field of the object
%
%   @synopsis   m=add_statemapping(m,{mapping})
%   @description adds the mapping <code>mapping</code> to the current
%   mapping state description.  
%
%MAN_PAGE_END

if  nargin == 1,
  m.statemapping={};
  set(m,'links',[]);
%orthervise
else
  error(checkval(themap,'mapping','the new mapping'));
  if isempty(m.statemapping),
    set(m,'statemapping',{themap});
%Antoine I do not like the following line, it is messy.    
%    set(m,'links',[ones(m.n_out,1) (1:m.n_out)']);
  else
    set(m,'statemapping',[m.statemapping {themap}]);
  end
end  

if nargout == 0,
	assignin('caller',inputname(1),m)
end
