function m = internal(varargin)
%INTERNAL Constructor for the internal class
%    
%    M=INTERNAL creates a new general system skeleton
%    
%    M=INTERNAL(NAME,N_IN,N_OUT) creates a new general system
%    with N_IN inputs and N_OUT outputs. The name NAME is
%    associated to it.
%    
%    M=INTERNAL(NAME,N_IN,N_OUT,N_STATE) creates a new general
%    system with N_IN inputs,  N_OUT outputs and N_STATE
%    states. The name NAME is associated to it.
%    
%    The class defines the following methods:
%    
%      ADD_STATEMAPPING: add a mapping for describing the
%          state of an internal object
%      CONICITY: compute the conicity stabity criterium
%      DISPLAY: Display an object of class internal
%      EVAL_STATE: computes the value of the state of a
%          system for some regressor
%      GET: gets the value of the attribute of an object
%      GLOB_INDICE: Compute the third stability indice for a
%          closed loop
%      IDENTIFY: Identify the system from data (abstact
%          method)
%      JACOB_CLOOP: Compute the jacobian with respect to the
%          state for a closed loop
%      JACOB_INPUTS: computes the jacobian of the model
%      JACOB_PARAMS: computes the jacobian of the model
%      LOC_INDICES: Compute the first and the second
%          stability indices for a closed loop
%      REGRESS:   SEEK_EQ: Use the optimisation       toolbox to find a
%          cl   SET: Set object properties <dt> stateregress
%          <dd>Compute the regressor for the state mapping
%    
%    See also: ALSO 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Constructor for the internal class
%
%   @synopsis	m=internal
%   @description  creates a new general system skeleton
%
%   @synopsis	m=internal(name,n_in,n_out)
%   @description  creates a new general system with <CODE>n_in</CODE> inputs
%	and <CODE>n_out</CODE> outputs. The name <CODE>name</CODE> is associated to it.
%	
%   @synopsis	m=internal(name,n_in,n_out,n_state)
%   @description  creates a new general system with <CODE>n_in</CODE> inputs, 
%	<CODE>n_out</CODE> outputs and <CODE>n_state</CODE> states. The name <CODE>name</CODE> is associated to it.
%	
%
%   @see also 
%
%MAN_PAGE_END

error(checkargs(varargin,[0 4],'any','numeric','numeric','numeric'));

m=[];
if nargin==0                   %if no arguments build an emty object
		m.n_state = 0;
		m.state = [];
		m.statemapping = {};
		m.statelinks = [];
		m.statelimits = [];
  	
  	f=system;
  	m=class(m,'internal',f);
  	
elseif nargin==1,              %if one argument
	%if type internal clone it
	if isa(varargin{1},'internal') & isa(varargin{1}.system ,'system'), 
	    m=varargin{1};
	%if type system add the fields    
	elseif isa(varargin{1},'system') & ~ isa(varargin{1},'internal'), 
	    m.n_state = 0;
		m.state = [];
		m.statemapping = {};
		m.statelinks = [];
		m.statelimits = [];
  		
  	    f=varargin{1};
        m=class(m,'internal',f);
	%if it is a structure (usually for update purposes)
	%try to recover all the common fields
	elseif isa(varargin{1},'struct')
		m.n_state = 0;
		m.state = [];
		m.statemapping = {};
		m.statelinks = [];
		m.statelimits = [];
  		
  		f=system;
	  	
	 	arg = struct(varargin{1});
	  	
	  	if isfield(arg,'system'),
	    f = system(arg.system);
	    arg = rmfield(arg,'system');
	    
	    fn=fieldnames(m);
	    for i=1:size(fn,1),
	      if isfield(arg,fn{i}),
		  	m=setfield(m,fn{i},getfield(arg,fn{i}));
	      end
	    end  
	  end
	  
	  m=class(m,'internal',f);
	else  %it must be something odd
	  error('wrong use of the constructor for the class external');
	end
elseif nargin>1,
  	
	if nargin == 4,
	    f=system(varargin{1:3});
		m.n_state = varargin{4};
		m.state = zeros(1,varargin{4});
		m.statemapping = {linear([varargin{1} ' linear system'],...
			varargin{2}+varargin{4}, varargin{4})};
		m.statelinks = [ones(varargin{4},1) (1:varargin{4})'];
		m.statelimits = [[-inf;inf] * ones(1,varargin{4})];
		set(f, 'mapping', {linear([varargin{1} ' linear system'],...
			varargin{2}+varargin{4}, varargin{3})});
		
	else
		f=system(varargin{:});
		m.n_state = 0;
		m.state = [];
		m.statemapping = {};
		m.statelinks = [];
		m.statelimits = [];
	end
  	
	m=class(m,'internal',f);
end

