function [x_m, x_c] = seek_eq(m,c,yd,v,options)
%SEEK_EQ Use the optimisation toolbox to find a cl
%    
%    -loop equil.
%    
%    SEEK_EQ(M,C,YD,OPTIONS) Finds the equilibrium of the
%    closed loop formed by the model M and the controller C
%    for a set point of YD and a perturbation of V. OPTIONS
%    contains all the options of the algorithm.
%    
%    See also: 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Use the optimisation toolbox to find a cl.-loop equil.
%
%   @synopsis	seek_eq(m,c,yd,options)
%   @description  Finds the equilibrium of the closed loop formed by the model <CODE>m</CODE>
%	and the controller <CODE>c</CODE> for a set point of <CODE>yd</CODE> and a perturbation of <CODE>v</CODE>.
%	<CODE>options</CODE> contains all the options of the algorithm.
%
%   @see 
%
%MAN_PAGE_END

if nargin<5,
	options = [];
	options.optim = foptions;
end

x0 = [get(m,'state') get(c,'state')];

opt = options.optim;
limm = get(m,'statelimits');
limc = get(c,'statelimits');

x = hkconstr('seek_eq_loc_cost',x0,opt,[limm(1,:) limc(1,:)],[limm(2,:) limc(2,:)],[],m,c,yd,v);

x_m = x(1:get(m,'n_state'));
x_c = x(1+get(m,'n_state'):end);
