function check(m); 
%CHECK checks the consistency of all the field of a lookup
%    object
%    
%    This function has been provided in order to make the
%    lookup class more robust since it checks a lookup object
%    for consistency of the data defined in its fields. If a
%    inconsistency is found, an  error message is displayed.
%    
%    CHECK(M) check the consistency of a lookup object.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose checks the consistency of all the field of a lookup object.
%   This function has been provided in order to make the lookup class
%   more robust since it checks a lookup object for consistency of
%   the data defined in its fields. If a inconsistency is found, an 
%   error message is displayed.
%
%   @synopsis check(m)
%   @description  check the consistency of a lookup object.
%
%MAN_PAGE_END

error(checkargs({m},1,'lookup'));

%Check the fields of the mapping superclass
check(m.mapping);

sm=struct(m);

if ~isfield(sm,'lookups'),
	error('object lookup should have a ''lookups'' attribute');
end

% Check the consistency between the lookups field and the number of inputs/outputs
if ndims(m.lookups) ~= get(m,'n_in'),
	error(['''lookups'' field is not the right size']);
end

