function out=eval(m,x,j)
%EVAL computes the value of the lookup for some input
%    
%    OUT=EVAL(M,REGRESSOR,J) returns the value OUT of the
%    output(s) J of lookup M given the input(s) X.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  computes the value of the lookup for some input.
%   
%   @synopsis out=eval(m,regressor,j)
%   @description  returns the value <code>out</code> of the output(s) <code>j</code> of
%   lookup <code>m</code> given the input(s) <code>x</code>.
%
%MAN_PAGE_END

error(checkargs({m x j},[2 3],'lookup','numeric','numeric'));

if nargin<3,
	j=1:get(m,'n_in');
end

% filler = cell(get(m,'n_in'),1);
% [filler{:}] = deal([1 2]);
% 
% for j=1:size(x,1),
% 	for i=1:get(m,'n_in'),
% 		brk = m.scales{i} > x(j,i);
% 		curs = find ([brk 1] ~= [0 brk]) - 1;
% 		lgth = length(m.scales{i});
% 		if (curs < lgth) & (curs > 0),
% 			levels(i) = (x(j,i) - m.scales{i}(curs))/(m.scales{i}(curs+1) - m.scales{i}(curs));
% 			values{i} = [curs curs+1];
% 		elseif curs == 0,
% 			levels(i) = 1;
% 			values{i} = [1 1];
% 		elseif curs == lgth,
% 			levels(i) = 0;
% 			values{i} = [lgth lgth];
% 		end
% 	end
% 
% 	corners{get(m,'n_in')+1} = m.lookups(values{:});	%Select the small interesting cube
% 
% 	for i=get(m,'n_in'):-1:1,
% 		corners{i} = (1-levels(i)) * corners{i+1}(filler{1:i-1},1) + levels(i) * corners{i+1}(filler{1:i-1},2);
% 	end
% 
% 	out(j,:) = corners{1};
% end

out = lookup_out(x',m.lookups,m.scales{:})';
