function m = lookup(varargin)
%LOOKUP Constructor for the lookup class
%    
%    M=LOOKUP creates a new lookup skeleton
%    
%    M=LOOKUP(NAME,N_IN,N_OUT) creates a new lookup	mapping
%    with N_IN inputs and N_OUT outputs. The name NAME is
%    associated to it.
%    
%    The class defines the following methods:
%    
%      CHECK: checks the consistency of all the field of a
%          lookup object
%      DENORMALISE: denormalises the model M
%      DISPLAY: Display an object of class lookup
%      DOUBLE: Convert the object to double
%      EVAL: computes the value of the lookup for some input
%      GET: gets the value of the attribute of an object
%      IDENTIFY: Identify the mapping from data
%      JACOB_INPUTS: computes the jacobian of the model
%      JACOB_PARAMS: computes the jacobian of the model
%      NORMALISE: normalises the model M
%      PREP_JACS:  
%      SET: Set object properties
%    
%    See also: MAPPING
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Constructor for the lookup class
%
%   @synopsis	m=lookup
%   @description  creates a new lookup skeleton
%
%   @synopsis	m=lookup(name,n_in,n_out)
%   @description  creates a new lookup  mapping with <CODE>n_in</CODE> inputs
%	and <CODE>n_out</CODE> outputs. The name <CODE>name</CODE> is associated to it.
%	
%
%   @see mapping
%
%MAN_PAGE_END

error(checkargs(varargin,[0 3],'any','numeric','numeric'));

m=[];
if nargin==0                   %if no arguments build an emty object
	m.lookups = [];
  	m.scales = {};
  	
  	f=mapping;
  	m=class(m,'lookup',f);
  	
elseif nargin==1,              %if one argument
	if isa(varargin{1},'lookup') & isa(varargin{1}.mapping ,'mapping'),   %if type taksug clone it
	    m=varargin{1};
	elseif isa(varargin{1},'mapping') & ~ isa(varargin{1},'lookup'), %if type mapping add the fields
	    m.lookups = [];
  		m.scales = {};
  		
  	    f=varargin{1};
        m=class(m,'lookup',f);
	else                              %if it is something else (usually for update purposes)
	    m.lookups = [];
  		
  		f=mapping;
	  	
	 	arg = struct(varargin{1});
	  	
	  	if isfield(arg,'mapping'),
	    f = mapping(arg.mapping);
	    arg = rmfield(arg,'mapping');
	    
	    fn=fieldnames(m);
	    for i=1:size(fn,1),
	      if isfield(arg,fn{i}),
		  	m=setfield(m,fn{i},getfield(arg,fn{i}));
	      end
	    end  
	  end
	  
	  m=class(m,'lookup',f);
	end
elseif nargin>1,
  m.lookups = [];
  m.scales = {};
  	
  f=mapping(varargin{:});
  	
  m=class(m,'lookup',f);
  
end



