function m=add_data(m,dataset,T)
%ADD_DATA add a input-output data set to the model
%    
%    This function is used to  inizialize the System 'data'
%    field with the model  input-output data. The data is
%    stored in the 'data' field which store. 
%    
%    M=ADD_DATA(M) removes all the input-output data from the
%    model M.
%    
%    M=ADD_DATA(M,DATA,T) puts DATA into the field 'data' of
%    the model M, DATA must be a data object. The optional
%    variable T specifies the sampling time of the model
%    (default continuous = 0).
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	add a input-output data set to the model.
%	This function is used to 
%   inizialize the System 'data' field with the model 
%   input-output data. The data is stored in the 'data' field which store. 
%
%   @synopsis	m=add_data(m)
%   @description   removes all the input-output data from the model <code>M</code>.
%
%   @synopsis	m=add_data(m,data,t)
%   @description  puts <code>data</code> into the field 'data' of the model <code>m</code>,
%   <code>data</code> must be a data object. The optional variable <code>t</code>
%	specifies the sampling time of the model (default continuous = 0).
%MAN_PAGE_END

m.data = [];         %clear all data
m.T = -1;

if nargin==1,      %do nothing
else
	
	if nargin<3,
		T = 0;
	end
	
	error(checkargs({m dataset T},3,'system','dataset','numeric'));
	
	set(m,'data',dataset);
	m.T = T;
	
end

if nargout == 0,
	assignin('caller',inputname(1),m)
end

