function m=clone_output(m,j,new_name)
%CLONE_OUTPUT clone the mapping associated to an output
%    
%    M = CLONE_OUTPUT(M,J,LABEL) clones the mapping associated
%    to the output J, and gives it the new name specified by
%    NEW_NAME. 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	clone the mapping associated to an output
%
%   @synopsis	m = clone_output(m,j,label)
%   @description clones the mapping associated to the output
%   <code>j</code>, and gives it the new name specified by
%   <code>new_name</code>. 
%
%MAN_PAGE_END  
  
error(checkval(j,'intpos','j',{1 1:get(m,'n_out') 0},[1 get(m,'n_out') 0]));

for i = j,
  new_mapping = m.mapping{m.links(i,1)};
  new_mapping.name = new_name;
  m = add_mapping(m, new_mapping);
  new_mapping_number=size(m.mapping,2);
  m.links(i,1)=new_mapping_number;
end  


