function m=denormalise(m);
%DENORMALISE normalises the system M
%    
%    This function denormalises a mapping in order to make fit
%    its limits to the original values before normalisation.
%    
%    M=NORMALISE(M) denormalises the system M
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose normalises the system M.
%	This function denormalises a mapping in order to make fit its limits
%	to the original values before normalisation.
%
%   @synopsis   m=normalise(m)
%   @description denormalises the system <CODE>m</CODE>
%
%MAN_PAGE_END  

%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 13/09/98 12:02
%
%	All rights reserved


check(m);

if ~isfield(m.opt,'original_limits')|any(m.limits(1,:) ~= 0)|any(m.limits(2,:) ~= 1),
	error(['Denormalise can only be used on a previously normalised model']);
end

m.limits = m.opt.original_limits;
