function m=normalise(m)
%NORMALISE normalises the model M
%    
%    M=NORMALISE(M) normalises the model M
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose normalises the model M.  
%
%   @synopsis   m=normalise(m)
%   @description normalises the model <CODE>m</CODE>
%
%MAN_PAGE_END  

check(m);

n_in = get(m,'n_in');
n_out = get(m,'n_out');

m.mapping = normalise(m.mapping);

opt = get(m,'opt');
limits = opt.original_limits;

theMinIn = limits(1,1:n_in)';
theMinOut = limits(1,n_in+1:n_in+n_out)';
theMaxIn = limits(2,1:n_in)';
theMaxOut = limits(2,n_in+1:n_in+n_out)';

N=diag(theMaxIn-theMinIn);

f2 = theMaxOut - theMinOut;
f3 = theMaxIn - theMinIn;
f4 = f3(:,ones(n_out,1))' ./ f2(:,ones(n_in,1));

if strcmpi(m.model_code{1},'projected')
	for i = 1:m.n_rules,
		f1 = theMinOut + squeeze(m.linears(1,1:n_in,i)) * theMinIn;
		
		m.linears(:,n_in+1,i) = (m.linears(:,n_in+1,i) - f1) ./ f2;
		m.linears(:,1:n_in,i) = m.linears(:,1:n_in,i) .* f4;
		m.centers(:,i) = (m.centers(:,i) - theMinIn) ./ f3;
		m.ivariances(:,:,i) = N*m.ivariances(:,:,i)*N;
	end
else
	for i = 1:m.n_rules,
		f1 = theMinOut + squeeze(m.linears(1,1:n_in,i)) * theMinIn;
		
		m.linears(:,n_in+1,i) = (m.linears(:,n_in+1,i) - f1) ./ f2;
		m.linears(:,1:n_in,i) = m.linears(:,1:n_in,i) .* f4;
	end
	for i = 1:n_in,
		m.mfs{i}(:,2:end) = (m.mfs{i}(:,2:end) - theMinIn(1,i)) / f3(1,i);
	end
end
