function m=split_rule(m,theSplittedRuleID,theSplittedRule,theLine,theNumChildren);

n_rules=m.n_rules;
dim = size(m.centers,1);

theOrigC=m.mapping.opt.PSCenters(1:dim,-theSplittedRuleID);
theOrigIVar=projclus(inv(m.mapping.opt.PSVars(:,:,-theSplittedRuleID)),(1:dim)');

theFinalC=m.centers(:,theSplittedRule);
theFinalIVar=m.ivariances(:,:,theSplittedRule);

[theOrigRot,theOrigHom]=eig(theOrigIVar);
theOrigHom=sqrt(theOrigHom);
theOrigRot=(theOrigRot*det(theOrigRot))';
theOrigM=theOrigHom*theOrigRot;

[theFinalRot,theFinalHom]=eig(theFinalIVar);
theFinalHom=sqrt(theFinalHom);
theFinalRot=(theFinalRot*det(theFinalRot))';
theFinalM=theFinalHom*theFinalRot;

for i=1:theNumChildren,
	theChildID(i)=m.mapping.opt.Hierarchy(theLine,i+1);
	if theChildID(i)>0,
		theNewOldC(:,i)=m.mapping.opt.PNCenters(1:dim,theChildID(i));
		theNewOldIV(:,:,i)=projclus(inv(m.mapping.opt.PNVars(:,:,theChildID(i))),(1:dim)');
	else
		theNewOldC(:,i)=m.mapping.opt.PSCenters(1:dim,-theChildID(i));
		theNewOldIV(:,:,i)=projclus(inv(m.mapping.opt.PSVars(:,:,-theChildID(i))),(1:dim)');
	end;
	theNewNewC(:,i)=theFinalC-inv(theFinalM)*theOrigM*(theOrigC-theNewOldC(:,i));
	theNewNewIV(:,:,i)=theFinalM'*inv(theOrigM)'*theNewOldIV(:,:,i)*inv(theOrigM)*theFinalM;
end;

m=add_rules(m,theNumChildren-1);
m.centers(:,end-theNumChildren+2:end)=theNewNewC(:,2:theNumChildren);
m.ivariances(:,:,end-theNumChildren+2:end)=theNewNewIV(:,:,2:theNumChildren);
m.mapping.opt.IDs=[m.mapping.opt.IDs theChildID(:,2:theNumChildren)];
m.centers(:,theSplittedRule)=theNewNewC(:,1);
m.ivariances(:,:,theSplittedRule)=theNewNewIV(:,:,1);
m.mapping.opt.IDs(:,theSplittedRule)=theChildID(:,1);
