function conicity(mat,range,cont,contr)

%CONICITY
% This function analyses the stability of a system defined by mat 
% with a controller named contr whose structure is cont.
%
% conicity(mat,range)
%    It analyses the system defined by mat without controller in a range of 
%     inputs: range. 
%
% conicity(mat,range,cont,contr)
%    It analyses the system defined by mat with the controller contr in a range of 
%     inputs: range.
%
%   mat =  struct that is the out of fm2mat
%   cont = Array of structures that define a hkfuzzy controller with the following fields:
%               ni         number of inputs
%               th         consequent parameters. These parameters must to be KCtrl and P in u = P - KCtrl*x (P: Affine term)
%               rls        rule matrix
%               mfs        membership function matrix
%               numStates  Number of States of the model
%   range = range of x1 x2 x3 ... It is a structure with the fields:
%           x1 range of x1
%           x2 range of x2
%           x3 range of x3
%             .
%             .
%   contr = controller's name
%
% See also: conse_cc, conse_co, conse_gr, coneval

%-----------------------------------------------------
% Departamento de Ingenieria de Sistemas y Automatica.
% Universidad de Sevilla 
%-----------------------------------------------------
% File: conicity
% Project: FAMIMO
% Block: conicity
% Use: 
%-----------------------------------------------------
% toolbox used: hkfuzzy
%
%-----------------------------------------------------
% Authors: Carolina Cuenca
% E-mail : ccp@cartuja.us.es
% Date: Oct 1998 
%-----------------------------------------------------
% Last update
% Date: 
% name: 
% Main changes : 
% Version Beta 0.0
%-----------------------------------------------------
% System : matlab 5 or higher
%     
%-----------------------------------------------------
% If you have any question please contact us :
% ccp@cartuja.us.es 
%-----------------------------------------------------
%-----------------------------------------------
%  Main variables description:
%
%-----------------------------------------------

disp('Stability Analisys: Conicity')
disp('  Computing...')
numStates=mat.numStates;

if nargin==4
   s='[A,B,C,D,Inputs,Outputs]=inabcd(mat.A,mat.B,mat.C,mat.D,{1 mat cont contr},''nlpartba'',[-1 1],range.x1';
   for i=2:numStates
      s=[s,',range.x' int2str(i)];
   end
   s=[s,');'];
   eval(s);
elseif nargin==2
   s='[A,B,C,D,Inputs,Outputs]=inabcd(mat.A,mat.B,mat.C,mat.D,{1 mat},''nlpartba'',[-1 1],range.x1';
   for i=2:numStates
      s=[s,',range.x' int2str(i)];
   end
   s=[s,');'];
   eval(s);
else
   disp('Error in the number of arguments');
end

fprintf('Conicity Index of conse_cc. The cone centre is in cc \n');
cc=conse_cc(Inputs,Outputs)
coneval(cc,A,B,C,D,Inputs,Outputs)

fprintf('Conicity Index of conse_co. The cone centre is in co \n');
q=eye(numStates)*1e8;
r=eye(numStates);
co=conse_co(A,B,q,r)
coneval(co,A,B,C,D,Inputs,Outputs)

fprintf('Conicity Index of conse_gr.\n');
options=foptions;
options(14)=50; % Number of Iterations
conse_gr(A,B,C,D,Inputs,Outputs,[],options);

disp('End of Conicity Analisys')
