%CLQLL  Lazy Learning Algorithm: Local combination of models.
%  
%   Ultra-fast version of the lazy learning algorithm.
%  
%  
%   Local models                   Combination of constant, 
%                                  linear, and quadratic models
%   Kernel functions               rectangular
%   Identification                 recursive mean and variance
%   Metric                         L1
%   Model selection                Minimum of leave-one-out error
%  
%   -------------------------------------------------------------------------
%  
%     
%     How to compile:
%     If a C compiler is correctly installed, and if matlab knows 
%     its path, the function can be compiled from the matlab
%     prompt, as follows:
%     
%  		 >> mex -O clqLL.c
%     
%     How to use:
%     From matlab, the resulting mex file can be called using 
%     the following syntax.
%     
%  		 >> [h,t] = clqLL(X,Y,Q,id_par);
%     
%     where 
%       INPUT:
%              X[n,m]              Examples: Input
%              Y[n,1]              Examples: Ouput
%              Q[q,m]              Query points
%              id_par[_,_]         Identification parameters 
%  				   (Details on dimensions follow)
%        OPTIONAL INPUT:
%  	       cmb_par[_,_]        Combination parameters
%  				   Default --> 1 
%  				   (Details on dimensions follow)
%  	       LAMBDA[1,1]         **ONLY PARTIALLY DOCUMENTED**
%  				   Initialization of the diagonal elements
%  				   of the local variance/covariance matrix
%  				   Default --> 1E6 
%  	       W[1,m]              **ONLY PARTIALLY DOCUMENTED**
%  				   Weights used to evaluate the distances
%  				   Default --> ones(1,m)
%  
%  
%  	  OUTPUT:
%  	       h[q,1]              Prediction with the selected number of 
%  				   neighbors and with the selected
%  				   combination
%              t[_,q]              Selected model for each query  
%  				   (Details on dimensions follow)
%  
%   -------------------------------------------------------------------------
%  
%     The function needs 4 mandatory inputs. If an optional input 
%     parameter is given, also all the preceding parameter MUST be
%     given.  E.G.  if W is specified, also LAMBDA and cmb_par...
%  
%     
%     The identification parameter can assume the following forms:
%   
%  	      1)   id_par[3,3]         | idm0  idM0 valM0 |   
%  				       | idm1  idM1 valM1 |
%  				       | idm2  idM2 valM2 |
%     
%  		   where [idmX,idMX] is the range in which the best
%  		   number of neighbors is searched when identifying
%  		   the local model of degree X and where valMX is the
%  		   maximum number of neighbors used in validation
%  		   for the model of degree X. This means that the
%  		   model of degree X identified with k neighbors,
%  		   is validated un the first v neighbors, where
%  		   v=min(k,valMX).
%
%  	      2)   id_par[3,2]         | idm0  idM0 |   
%  				       | idm1  idM1 |
%  				       | idm2  idM2 |
%     
%  		   where idmX and idMX have the same role they have in 
%  		   point 1, and valMX is by default set to idMX:
%  		   each model is validated on all the neighbors
%  		   used in identification. 
%     
%     
%  	      3)   id_par[3,1]         | c0 |
%  				       | c1 |
%  				       | c2 | 
%     
%  		   Here idmX and idMX are obtained according to the 
%  		   following fotmulas:
%  		    idmX = 3 * no_parX * cX     idMX = 5 * no_parX * cX 
%  		   where no_parX is the number of parameter of the model
%  		   of degree X. Recommended choice: cX = 1.
%                  As far as the valMX are concerned, they get the
%                  default value as in point 2.
%
%
%     If cmb_par is not given, the best model is selected among those
%     identified (as specified by id_par). In this case, the model
%     combination reduces to a simple "model selection".
%     The default value for cmb_par is 1 as it will be clear from what
%     follows.   If given, cmb_par can assume the following to forms:
%  
%  	      1)   cmb_par[3,1]        | cmb0 |
%  				       | cmb1 |
%  				       | cmb2 |
%     
%  		   where cmbX is the number of models of degree X
%  		   that will be included in the local combination. 
%  		   Each local model will be therfore a combination of 
%  		   "the best cmb0 models of degree 0", 
%  		   "the best cmb1 models of degree 1", and
%  		   "the best cmb2 models of degree 1" identified 
%                  as specified by id_par.
%     
%  	      2)   cmb_par[1,1]        | cmb |
%     
%  		   where cmb is the number of models that will be
%  		   combined, disregarding any constraint on the degree
%  		   of the models that will be considered.  Each local
%  		   model will be therfore a combination of "the best
%  		   cmb models", identified as specified by id_par.
%     
%  	      
%     The second output t, is a matrix in which the i-th line contains
%     the parameters of the local model used for the i-th query.
%  
%     *** IMPORTANT REMARK *** a translation of the axes is considered 
%     which centers all the local models in the respective query point.
%  
%      1)  If according to id_par and cmb_par only constant models are 
%      	   considered t[1,q] reduces to a vector in which each "line" 
%          is the single parameter of a constant model.
%
%      2)  If at least one model of degree 1 and no model of degree 2
%          are considered each line of t[d+1,q] is a vector that 
%          containes d+1 parameters: 
%           
%                                | a0 a1 a2 ... | 
%
%          where a0 is the constant term of the model and  a1 is
%          the parameter associated with the 1-st input
%          variable x1, etc...
%
%      3)  If at least one model of degree 2 is considered, each 
%      	   line of t[z,q], where z = (d+1)*(d+2)/2, is a vector that 
%          contains the parameters of a local model with the 
%          following convention:
%      	
%      	      | a0 a1 a2 ... a11 a12 ... a22 a23 ... a33 a34 ... |
%      	
%      	   where a0 a1 a2 ... have the same meaning as in the previous
%      	   case and a11 is the parameter of the quadratic term (x1)^2,
%      	   and a12 is the parameter of the cross-term x1*x2, etc...
%

%   The Lazy Learning Toolbox --- Version 1.0:
%   -------------------------------------------------------------------------
%   Copyright (c) 1999 by Mauro Birattari & Gianluca Bontempi
%   -------------------------------------------------------------------------
%  
%               Mauro Birattari                   Gianluca Bontempi
%                   IRIDIA                             IRIDIA 
%       Universite' Libre de Bruxelles     Universite' Libre de Bruxelles
%              mbiro@ulb.ac.be                    gbonte@ulb.ac.be
%  
%   -------------------------------------------------------------------------
%   Mao: May 7, 1999
