function execute_hook

warning off

which_button = find(btnstate(gcf,'Main_Panel'));
params = get(gcf,'UserData');

switch which_button,
	case 1,
		exec_data(params);
	case 2,
		exec_dynamics(params);
	case 3,
		exec_identification(params);
	case 4,
		exec_visualisation(params);
	case 6,
		exec_stability(params);
end	

function exec_data(params)
in=[];
out=[];
if isempty(params.data),
	if isempty(params.output),
		in = evalin ('base',params.input);
		params.m=add_data(params.m,in);
	else
		in = evalin ('base',params.input);
		out = evalin ('base',params.output);
		params.m=add_data(params.m,in,out);
	end
else
	params.m=add_data(params.m,params.data,params.input,params.output);
end
set(gcf,'Userdata',params);
redraw_hook(1);


function exec_dynamics(params)
if isempty(params.ny)&isempty(params.nu)&isempty(params.nd),
	params.m=set_static(params.m);
else
	params.m=add_dynamics(params.m,params.ny,params.nu,params.nd);
end
set(gcf,'Userdata',params);
redraw_hook(1);

function exec_identification(params)
which_model = find(btnstate(gcf,'Model_Panel'));
loc_params=[];
switch which_model,
	case 1,
		refs={'cluslms','fmclust','incrsie','cluslev','randlm'};
		loc_params = evalin ('base',params.ident_params);
		params.m=identify(params.m,refs{params.method},loc_params);
	case 2,
		loc_params = evalin ('base',params.ident_params);
		params.m=identify(params.m,'standard',loc_params);
	case 3,
		%loc_params = evalin ('base',params.ident_params);
		%params.m=identify(params.m,'standard',loc_params);
end
set(gcf,'Userdata',params);
redraw_hook(1);


function exec_visualisation(params)
figure;
loc_params = evalin ('base',params.visual_params);
plot(params.m,params.xval_data,loc_params);

function exec_stability(params)
eval(params.dat);
mat=fm2mat(FM);
assignin('base','mat',mat);
if params.lmi,
	estado=0;
	save dat estado;
	if params.cc
		disp('Stability Analysis: LMI')
		pwsauto(FM,cont,mat.numStates,FM(1).ni,mat.numRules);
	else
		disp('Stability Analysis: LMI')
		pwsauto(FM,[],mat.numStates,FM(1).ni,mat.numRules);
	end
elseif params.coni,
	estado=0;
	save dat estado;
	if params.cc
		conicity(mat,range,cont,params.cont);
	else
		conicity(mat,range);
	end
elseif params.freq,
	estado=1;
	numStates=mat.numStates;
	sist = params.sist;
	open_system(sist);
	set_param([sist,'/','Inport'],'PortWidth',num2str(numStates));
	close_system(sist,1);
	if params.cc
		contr = params.cont;
		%cont=1;
	else
		contr=0;
		cont=[];
	end
	assignin('base','contr',contr);
	assignin('base','cont',cont);
	options=foptions;
	options(14)=10;
    frequres(mat,Vect,sist,options);
	save dat estado cont contr mat Vect sist;
end
