function m = fromfm(fm,m)
%FROMFM import the fields of a fm model inside a taksug
%    model
%    
%    FROMFM(FM,M) get fields from FM and put them inside M
%    
%    See also: 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	import the fields of a fm model inside a taksug model.
%
%   @synopsis	fromfm(fm,m)
%   @description  get fields from <CODE>fm</CODE> and put them inside <CODE>m</CODE>
%
%   @see 
%
%MAN_PAGE_END

  
error(checkargs({fm m},2,'struct','taksug'));

rem_rules(m);

if fm.ante(1)==1,
	m=add_rules(m,fm.c(1),{'productspace' 'inversedist' 'linear'});	
	% old set(m,'centers',fm.V{1}(:,1:end-1)','m',fm.m(1),'ivariances',fm.M{1});
	set(m,'centers',fm.V{1}','m',fm.m(1),'ivariances',fm.M{1});
	set(m,'linears',reshape(fm.th{1}',[1 size(fm.V{1},2)+1 fm.c(1)]));
	
	opt=struct('ClusCenters',[fm.V{1}';eval(m,fm.V{1},1)'],'ClusVars',fm.P{1});
	set(m,'opt',opt);
else
	m=add_rules(m,fm.c(1),{'projected' 'inversedist' 'linear'});
	set(m,'mfs',fm.mfs{1});
	set(m,'rls',fm.rls{1});
	set(m,'linears',reshape(fm.th{1}',[1 size(fm.V{1},2)+1 fm.c(1)]));
	opt=struct('ClusCenters',fm.V{1}','ClusVars',fm.P{1});
	set(m,'opt',opt);
end

