function msg = checkargs(args,n,varargin)
%CHECKARGS Check the arguments against specific prototype
%    
%    CHECKARGS(ARGS,N,TYPE1,TYPE2,TYPE3,...) checks the that
%    arguments list inside the cell array LIST is compatible
%    with the description given by N, TYPE1, TYPE2, TYPE3. If
%    type... is equal to any, the type is not checked. N is a
%    vector containing the minimum and the maximum number of
%    arguments.
%    
%    See also: ERROR
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Check the arguments against specific prototype
%
%   @synopsis	checkargs(args,n,type1,type2,type3,...)
%   @description  checks the that arguments list inside the cell array <CODE>list</CODE>
%	is compatible with the description given by <CODE>n</CODE>, <CODE>type1</CODE>, <CODE>type2</CODE>, <CODE>type3</CODE>.
%	If type... is equal to any, the type is not checked. <CODE>n</CODE> is a vector containing the minimum
%	and the maximum number of arguments.
%
%   @see error
%
%MAN_PAGE_END

msg = '';
if (length(args) < n(1))|(length(args) > n(end)),
	if (n(1) == n(end)),
		msg = ['Wrong type of arguments: this calling convention expects ' num2str(n(1)) ' arguments.'];
	else
		msg = ['Wrong type of arguments: this calling convention expects ' num2str(n(1)) '-' num2str(n(end)) ' arguments.'];
	end
	return
end

for i=1:length(args),
	
	% Each arg can be either a cell (for different options), either a string
	if (iscell(varargin{i}))
		thearg = varargin{i};
	else
		thearg = varargin(i);
	end
	
	estring = '';
	flag = 0;
	
	for j = 1:length(thearg),
		switch thearg{j},
			case 'char',
				estring = [estring ' or char'];
				flag = flag + ischar(args{i});
			case 'numeric',
				estring = [estring ' or numeric'];
				flag = flag + isnumeric(args{i});
			case 'cell',
				estring = [estring ' or cell'];
				flag = flag + iscell(args{i});
			otherwise,
				if ~strcmp(varargin{i},'any'),
					estring = [estring ' or ' thearg{j}];
					flag = flag + isa(args{i}, thearg{j});
				else
					flag = 1;
				end
		end
		
		if ~flag,
			msg = ['Argument ' num2str(i) ' should be of type ' estring(5:end) ' in this calling convention.'];
			return
		end
	end
end	
