function res=iscompat(a,b)
%ISCOMPAT Check that two matrices have the same size
%    
%    RES=ISCOMPAT(A,B) checks if A and A have the same size.
%    Unlike, size(A) == size(B), iscompat works if there are
%    singleton dimension in one of the matrices and if the
%    matrices have uncompatible sizes.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Check that two matrices have the same size
%
%   @synopsis	res=iscompat(a,b)
%   @description  checks if <CODE>a</CODE> and <CODE>a</CODE> have the same size.
%	Unlike, size(<CODE>a</CODE>) == size(<CODE>b</CODE>), iscompat works if there
%	are singleton dimension in one of the matrices and if the matrices have uncompatible
%	sizes.
%
%MAN_PAGE_END

a = squeeze(a);
b = squeeze(b);

na = ndims(a);
nb = ndims(b);

if na == nb,
	sa = size(a);
	sb = size(b);
	res = isequal(sa(na),sb(nb));
else
	res = 0;
end
