%define the model of the process ot control
pman_model=external('pression manifold system',2,1);
pman_model=set(pman_model,'T',0.005);
pman_model=add_dynamics(pman_model,2,[1 1],[1 1]);
training_set=dataset('pman_id_set_small.mat',{'MTC','N','pman'});
validation_set=dataset('pman_val_set_small.mat',{'MTC','N','pman'});
pman_model=add_data(pman_model,training_set);
set(pman_model,'limits',[0 800 100; 100 3400 1024]);


%linear model
linear_mapping=linear('linear mapping',4,1);
pman_model=add_mapping(pman_model,linear_mapping);
pman_model=set(pman_model,'links',[1 1]);

pman_model=identify(pman_model,[1]);

flat_error(pman_model,1);
flat_error(pman_model,validation_set,1);
simulation_error(pman_model,1,'plot')
figure;
simulation_error(pman_model,validation_set,1,'plot')
figure;

%lazy model
lazy_mapping=lazy('lazy mapping',4,1);
pman_model=add_mapping(pman_model,lazy_mapping);
pman_model=set(pman_model,'links',[2 1]);

pman_model=identify(pman_model,[1],struct('id_par',[0 0; 15 30; 0 0],'cmb_par',[4]));

flat_error(pman_model,1);
flat_error(pman_model,validation_set,1);
simulation_error(pman_model,1,'plot')
figure;
simulation_error(pman_model,validation_set,1,'plot')
figure;

%fuzzy model
taksug_mapping=taksug('taksug mapping',4,1);
pman_model=add_mapping(pman_model,taksug_mapping);
pman_model=set(pman_model,'links',[3 1]);

pman_model=identify(pman_model,[1],struct('method','fmclust','n_rules',8));
flat_error(pman_model,1);
flat_error(pman_model,validation_set,1);

pman_model=clone_output(pman_model,1,'taksug mapping2');
pman_model=identify(pman_model,[1],struct('method','cluslms','n_rules',8));
flat_error(pman_model,1);
flat_error(pman_model,validation_set,1);

pman_model=clone_output(pman_model,1,'taksug mapping3');
pman_model=identify(pman_model,[1],struct('method','tsgklmsxv', ...
					  'min_n_rules',5,'max_n_rules',13));

flat_error(pman_model,1);
flat_error(pman_model,validation_set,1);
simulation_error(pman_model,1,'plot')
figure;
simulation_error(pman_model,validation_set,1,'plot')














