function report = leave1out(algo,learnset,p1,p2);
%LEAVE1OUT LEAVE1OUT performs the leave-one-out validation
%    and computes the confusion matrix, error rates and Kappa
%    inside a report structure
%    
%    REPORT = LEAVE1OUT(ALGO, LEARNSET, P1, P2) See also: CUT,
%    BOOTSTRAP.
%    
%    

%MAN_PAGE_BEGIN
%@purpose LEAVE1OUT performs the leave-one-out validation and computes the confusion matrix,
% error rates and Kappa inside a report structure.
%
%@synopsis REPORT = LEAVE1OUT(ALGO, LEARNSET, P1, P2)
%@Description <br>
%    ALGO : 'C45', 'FKNN', 'LDA'<br>
%    LEARNSET : a dataset objet representing the learning set of a database.<br>
%    P1, P2 : possible parameters (e.g. Cf and MINOBJ for C4.5 and N for FKNN)<br>
%    
%@see CUT, BOOTSTRAP.
%MAN_PAGE_END

% Copyright (c) 9/08/99.
% $Revision: 1.0 $ Patrice Latinne

nc=get(learnset,'nc');
ns=get(learnset,'ns');
M=zeros(nc,nc);
switch upper(algo)
case 'C45'
   learnset=downclass(learnset);
   trdata=get(learnset,'contdata');
   classesList = get(learnset,'classeslist')';
   noms = get(learnset,'variables');
   noclpos=find(~strcmp(learnset.vartypes,'class'));
   noms=noms(noclpos);
   classes = get(learnset,'classes');
   for i=1:length(noms)
      symbol{i} = {};
      special{i} = [0];       
      nsymb{i} = [0];   
   end
   for i=1:ns 
      tst = trdata(i,:);
      if i==1 
         tr=trdata(1:end-1,:);        
      elseif i==ns 
         tr=trdata(2:end,:);
      else  
         tr=[trdata(1:i-1,:);trdata(i+1:end,:)];
      end
      [tree,ptree]= build_c45(noms',special,symbol,nsymb,classesList,tr,classes,p1,p2);
      test_cl= classify_c45(noms',special,symbol,nsymb,classesList,ptree,tst)+1;
      M(classes(i)+1,test_cl)=M(classes(i)+1,test_cl)+1;
   end   
case 'FKNN'
case 'LDA'
end

D  = sum(M.*eye(nc,nc));
ni = sum(M');

Drel = D./ni;

overall_acc=trace(M)/sum(sum(M));
average_acc=sum(Drel)/nc;           %%% == mean(Drel);
numKi = zeros(1,nc);
denomKi = zeros(1,nc);
for i=1:nc
   numKi(i)   = sum(sum(M)) * D(i) - sum(M(i,:)) * sum(M(:,i));
   denomKi(i) = sum(sum(M)) * sum(M(i,:)) - sum(M(i,:)) * sum(M(:,i));
end
Kappai = numKi ./ denomKi;
Kappa  = sum(numKi)/sum(denomKi) ;

Mrel = M./ repmat(ni',1,nc);
report.M    = M;
report.Mrel = Mrel;
report.Average_acc = average_acc;
report.Overall_acc = overall_acc; %%% global good classification rate
report.D    = D;
report.Drel = Drel;
report.Kappai = Kappai;
report.Kappa  = Kappa;
