function [ir, or] = regress(m,j)
%REGRESS extracts the regressors from the data
%    
%    This function uses the dynamical system representation
%    stored in the 'dynamics' field to extract the regressors
%    form the input-output data stored in the 'data' field. 
%    The function returns the input regressors R_IN in a cell
%    array.	Each element of the cell array is a regressor
%    associated with an output.  Each regressor is an array of
%    size SIZE_REGRESSOR * NUM_EXAPLES, where SIZE_REGRESSOR
%    depends from the structure of the regressor defined in
%    the dynamical description of the system, and NUM_EXAPLES
%    is the number of exaples given in the input-output data
%    set. R_IN is a cell array returing the corrispondent
%    output of each regressor taken from the output data set.
%    Each entry in the cell array is a vector of size 1 *
%    NUM_EXAPLES. 
%    
%    [R_IN,R_OUT]=GET_REGRESSORS(M) extracts the regressors
%    from the model M, for all the outputs of the system.
%    
%    [R_IN,R_OUT]=GET_REGRESSORS(M,J) extracts the regressors
%    from the model M, for all the outputs of the system
%    defined in the array J.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose extracts the regressors from the data. This function uses the
%   dynamical system representation stored in the 'dynamics' field to
%   extract the regressors form the input-output data stored in the 'data'
%   field.  The function returns the input regressors <code>r_in</code> in a
%   cell array.  Each element of the cell array is a regressor associated
%   with an output.  Each regressor is an array of size <code>size_regressor
%   * num_exaples</code>, where <code>size_regressor</code> depends from the
%   structure of the regressor defined in the dynamical description of the
%   system, and <code>num_exaples</code> is the number of exaples given in
%   the input-output data set. <code>r_in</code> is a cell array returing
%   the corrispondent output of each regressor taken from the output data
%   set. Each entry in the cell array is a vector of size <code>1 *
%   num_exaples</code>. 
%
%   @synopsis   [r_in,r_out]=get_regressors(m)
%   @description extracts the regressors from the model <code>m</code>,
%   for all the outputs of the system.
%
%   @synopsis   [r_in,r_out]=get_regressors(m,j)
%   @description extracts the regressors from the model <code>m</code>,
%   for all the outputs of the system defined in the array <code>j</code>.
%
%MAN_PAGE_END 

check(m);

if get(m,'n_out') <=0,
  error ('the number of the outputs has not yet been initialized');
end
if get(m,'n_in') <=0,
  error ('the number of the outputs has not yet been initialized');
end

if (nargin < 2)|isempty(j),
  j = 1:get(m,'n_out');
end

error(checkval(j,'intpos','j',{1 1:get(m,'n_out') 0},[1 get(m,'n_out')]));

dd = get(get(m,'data'),'contdata');
if isempty(dd)
  error('the data of the system has not been yet defined');
end 

data_in=dd(:,1:get(m,'n_in'));
data_out=dd(:,get(m,'n_in')+1:end);

%check the description of the dynamics
dynamics=get(m,'dynamics');
if isempty(dynamics)
  error('the dynamics of the system has not been yet defined');
end 

[ir, or] = build_regressors([data_out data_in],dynamics.ny,dynamics.nu,dynamics.nd);

ir= {ir{j}};
or= {or{j}};



