function out=eval_state(m,varargin)
%EVAL_STATE computes the value of the state of a system
%    for some regressor
%    
%    OUT=EVAL_STATE(M,R,J) returns the value OUT of the
%    state(s) J of mapping M given the input regressor R.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  computes the value of the state of a system for some regressor.
%   
%   @synopsis out=eval_state(m,r,j)
%   @description  returns the value <code>out</code> of the state(s) <code>j</code> of
%   mapping <code>m</code> given the input regressor <code>r</code>.
%
%MAN_PAGE_END

error(checkargs([{m} varargin],[2 3],'system',{'numeric' 'cell'},'numeric'));

r = varargin{1};
if (nargin == 2)|isempty(varargin{2}),
	j = 1:get(m,'n_out');
else
	j = varargin{2};
end

if ~iscell(r),
	sr = r;
	r = {};
	for ii=1:length(j),
		r{ii} = sr;
	end
end

listlinks = m.statelinks(j,:);

k = 0;
for i = unique(listlinks(:,1)),
	k = k + 1;
	sub = find(listlinks(:,1) == i);
	out(sub) = eval(m.statemapping{i},r{k},listlinks(sub,2));
end
