function m = identify(m,j,options)
%IDENTIFY Identify the system from data (abstact method)
%    
%    M = IDENTIFY(M,IN,OUT,OPTIONS) performs the
%    identification of the model M using the data embeded
%    inside the object. Use OPTIONS in order to specify the
%    identification method and options.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Identify the system from data (abstact method)
%
%   @synopsis	m = identify(m,in,out,options)
%   @description  performs the identification of the model <CODE>m</CODE> using
%	the data embeded inside the object. Use <CODE>options</CODE> in order
%	to specify the identification method and options.
%
%   @see_also eval
%
%MAN_PAGE_END

if (nargin < 2)|isempty(j),
	j = 1:get(m,'n_out')+m.n_state;
end

if nargin < 3, options = []; end

error(checkargs([{m j options}],[1 3],'system','numeric','any'));

totn = get(m,'n_state') + get(m,'n_out');
error(checkval(j,'intpos','j',{1 1:totn 0},[1 totn]));

idxs_s = find(j<=get(m,'n_state'));
idxs = find(j>get(m,'n_state'));

j_s = j(idxs_s);
j = j(idxs) - get(m,'n_state');

listlinks = get(m,'links');
listlinks = listlinks(j,:);
listlinks_s = m.statelinks(j_s,:);

[ir, or] = regress(m,j);

k = 0;
for i = unique(listlinks(:,1)),
	k = k + 1;
	sub = find(listlinks(:,1) == i);
	options.outputs = listlinks(sub,2);
	map = get(m,'mapping');
	map{i} = identify(map{i},ir{k},or{k},options);
	set(m,'mapping',map);
end

[ir_s, or_s] = stateregress(m,j_s);

k = 0;
for i = unique(listlinks_s(:,1)),
	k = k + 1;
	sub = find(listlinks_s(:,1) == i);
	options.outputs = listlinks_s(sub,2);
	m.statemapping{i} = identify(m.statemapping{i},ir_s{k},or_s{k},options);
end
