function out=jacob_params(m,varargin)
%JACOB_PARAMS computes the jacobian of the model
%    
%    JACOB_PARAMS(M,R)   computes for each output the jacobian
%    of the model with respect to the parameters at regressor
%    R.
%    
%    JACOB_PARAMS(M,R,J)   computes for output(s) J the
%    jacobian of the model with respect to the parameters at
%    regressor REGRESSOR.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  computes the jacobian of the model.
%
%   @synopsis jacob_params(m,r)  
%   @description computes for each output the jacobian of
%  the model with respect to the parameters at regressor <CODE>r</CODE>.
%
%   @synopsis jacob_params(m,r,j)  
%   @description computes for output(s) <CODE>j</CODE> the jacobian of
%  the model with respect to the parameters at regressor <CODE>regressor</CODE>.
%
%
%MAN_PAGE_END    


%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 10/12/1997
%
%	All rights reserved


error(checkargs([{m} varargin],[2 3],'mapping','numeric','numeric'));

check(m);

%?????
