function out=jacob_inputs(m,varargin)
%JACOB_INPUTS computes the jacobian of the model
%    
%    The procedure for computing the jacobian depends on the
%    underlying representation  of the model. The result OUT
%    is an array of size number of outputs * number of inputs
%    containing the derivatives of the outputs with respect to
%    the inputs.
%    
%    JACOB_INPUTS(M,X) computes for each output the jacobian
%    of the model with respect to the x (the input of the
%    lazy) at point X.
%    
%    JACOB_INPUTS(M,X,J) computes for output J the jacobian of
%    the model with respect to the x (the input of the lazy)
%    at point X.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose    computes the jacobian of the model.
%   The procedure for computing the jacobian depends on the underlying representation 
%   of the model. The result <code>out</code> is an array of size number of outputs * number of inputs
%   containing the derivatives of the outputs with respect to the inputs.
%
%   @synopsis   jacob_inputs(m,x)
%   @description computes for each output the jacobian of
%   the model with respect to the x (the input of the
%   lazy) at point <CODE>x</CODE>.
%
%   @synopsis   jacob_inputs(m,x,j)
%   @description computes for output J the jacobian of
%   the model with respect to the x (the input of the
%   lazy) at point <CODE>x</CODE>.
%
%MAN_PAGE_END

%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 10/12/1997
%
%	All rights reserved

error(checkargs([{m} varargin],[2 3],'lazy','numeric','numeric'));

x = varargin{1};

if size(x,1)>1,
  error('jacob_inputs for only one regressor is supported');
end  

if (nargin == 2)|isempty(varargin{2}),
	j = 1:get(m,'n_out');
else
	j = varargin{2};
end

out = zeros(size(j,2),get(m,'n_in'));

for i=1:size(j,2)      
  [no_use,jacobian]= clqLL(m.examples_x,m.examples_y(:,j(i)),x,...
			   m.id_par,m.cmb_par);
  if size(jacobian,1)>1,
    out(j(i),:)=jacobian(2:(get(m,'n_in')+1))';
  end  
end
