function m=incr_test(m,par)
%FIT_LINEARS performs a incremental optimisation of the rule base
%    using a method developped by Siemens
%
%    M=INCR_TEST(M,PAR) LMS fit of the linears for each output of
%    the model M.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose   performs a incremental optimisation of the rule base
%    using a method developped by Siemens
%
%   @synopsis   m=incr_test(m,par)
%   @description  LMS fit of the linears for each output of
%   the model <CODE>m</CODE>.
%
%   @synopsis   m=fit_linears(m,r)
%   @description  LMS fit of the linears for outputs <CODE>m</CODE> of
%   the model <CODE>m</CODE>. 
%
%   @synopsis   m=fit_linears(m,r,type)
%   @description  lets specify the type of the fit. 0 is the
%   defaults and leads to a cclassical LMS fit. 1 leads to a local fit.
%
%MAN_PAGE_END   

%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 13/09/98 11:12
%
%	All rights reserved

if (nargin<2), par=[]; end

if (~isfield(par,'ErrorCriteria') | isempty(par.ErrorCriteria)), par.ErrorCriteria=1; end
if (~isfield(par,'Thresold') | isempty(par.Thresold)), par.Thresold=1; end
if (~isfield(par,'m') | isempty(par.m)), par.m=1.5; end
if (~isfield(par,'OutputRelation') | isempty(par.OutputRelation)), par.OutputRelation=[]; end
if (~isfield(par,'FileName') | isempty(par.FileName)), par.FileName='model'; end
if (~isfield(par,'ErrorMax') | isempty(par.ErrorMax)), par.ErrorMax=0.01; end
if (~isfield(par,'n_rules_max') | isempty(par.n_rules_max)), par.n_rules_max=5; end

[in,out]= get_regressors(m);
dyn = get(m,'dynamics');

j=1;
while (j<=get(m,'n_out')),
	ref=[dyn.ny(j,:) dyn.nu(j,:) dyn.nd(j,:)];
	k=j;
	while (k+1<=get(m,'n_out')) & all([dyn.ny(k+1,:) dyn.nu(k+1,:) dyn.nd(k+1,:)] == ref),
		k=k+1;
	end
	
	data=in{j};
	n_in=size(data,2);
   
   for ii=j:k,
		data=[data out{ii}];
	end
	%Look for which inputs we are allowed to use the same model
	models=ModelCalculation(data,n_in,par.n_rules_max,par.ErrorMax,par.FileName,par.OutputRelation,par.m,par.Thresold,par.ErrorCriteria);
	%Plot the models error
	[MeanError,MaxError] = ModelResults(models);
	%Allow the user to select a model
	
	p=[];
	p.e1=MeanError;
	p.e2=MaxError;
	p.obj=[];
	p.val=0;
	set(gcf,'userdata',p);
	zoom off;
	
	set(gcf,'WindowButtonDownFcn','siemens_hook(1)');
	set(gcf,'WindowButtonMotionFcn','siemens_hook(2)');
	set(gcf,'WindowButtonUpFcn','siemens_hook(3)');
	
	res=0;
	while ~res,
		t=waitforbuttonpress;
		if ~t,
			params=get(gcf,'userdata');
			res = params.val;
		end
	end
	
	close(gcf);
	model = models(res).Model;
	for ii=j:k,
		m=rem_rules(m,ii);
		m=add_rules(m,res,{'productspace' 'inversedist' 'linear'},ii);
		for i=1:res,
			m.description{ii}.centers(:,i) = model.MembershipFunctionCenter(i,1:end-1);
			m.description{ii}.ivariances(:,:,i) = diag(model.ScaleFactor(1:end-1).^2);
			m.description{ii}.linears(:,:,i) = model.LocalLinearModel(i,:,ii-j+1);
		end
        if isfield(m.description{ii}.opt,'sav_linears'),  %clear the copy of the linears
     	  rmfield(m.description{ii}.opt,'sav_linears');
	    end
	end
	model.LocalLinearModel
	j=k+1;
end
