function m=normalise(m);
%NORMALISE normalises the model M
%    
%    This function normalizes a mapping in order to make fit
%    its limits to the interval [0,1]
%    
%    M=NORMALISE(M) normalises the model M
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose normalises the model M.
%	This function normalizes a mapping in order to make fit its limits
%	to the interval [0,1]
%
%   @synopsis   m=normalise(m)
%   @description normalises the model <CODE>m</CODE>
%
%MAN_PAGE_END  

%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 13/09/98 12:02
%
%	All rights reserved


check(m);

if m.n_in<0,
	error([Undefined number of inputs]);
end

if m.n_in<0,
	error([Undefined number of outputs]);
end

if any(isinf(m.limits)),
	error([Normalise can not be used on a function which has infinite limits]);
end

if any((m.limits(2,:) - m.limits(1,:)) < 0),
	error([Normalise can not be used on a function which has invalid limits]);
end

if isfield(m.opt,'original_limits')
	warning('The function has already being normalised');
	return;
end

m.opt.original_limits = m.limits;

m.limits(1,:) = 0;
m.limits(2,:) = 1;
