function check(m); 
%CHECK checks the consistency of all the field of a linear
%    object
%    
%    This function has been provided in order to make the
%    linear class more robust since it checks a linear object
%    for consistency of the data defined in its fields. If a
%    inconsistency is found, an  error message is displayed.
%    
%    CHECK(M) check the consistency of a linear object.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose checks the consistency of all the field of a series object.
%   This function has been provided in order to make the series class
%   more robust since it checks a series object for consistency of
%   the data defined in its fields. If a inconsistency is found, an 
%   error message is displayed.
%
%   @synopsis check(m)
%   @description  check the consistency of a series object.
%
%MAN_PAGE_END

error(checkargs({m},1,'series'));

%Check the fields of the mapping superclass
check(m.mapping);

sm=struct(m);

if ~isfield(sm,'mapping1'),
	error('object linear should have a ''mapping1'' attribute');
end
if ~isfield(sm,'mapping2'),
	error('object linear should have a ''mapping2'' attribute');
end

if ~isfield(sm,'links'),
	error('object linear should have a ''links'' attribute');
end


% Check the links fiels
if ~isfield(sm.links,'Sy1'),
	error('attribute ''links'' should have a Sy1 field');
end

if ~isfield(sm.links,'Sy2'),
	error('attribute ''links'' should have a Sy2 field');
end

if ~isfield(sm.links,'Sy3'),
	error('attribute ''links'' should have a Sy3 field');
end

if ~isfield(sm.links,'Sm1'),
	error('attribute ''links'' should have a Sm1 field');
end

if ~isfield(sm.links,'Sm2'),
	error('attribute ''links'' should have a Sm2 field');
end

if ~isfield(sm.links,'Sm21'),
	error('attribute ''links'' should have a Sm21 field');
end

