function f=plot(m)
%PLOT plot the system
%    
%    F=PLOT(M) 
%    
%    See also: 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	plot the system
%
%   @synopsis	f=plot(m)
%   @description  
%
%   @see 
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 4/06/99

% Initialises the figure

f = gcf;
clf;

ud = struct('m',m);
ud.m = m;
ud.f1 = uicontrol(	'style','listbox',...
					'units','normal',...
					'min',0,...
					'max',length(m.mapping),...
					'BackgroundColor',[1 1 1],...
					'position',[0.01 0.75 0.2 0.23]);
					
ud.m1 = uicontrol(	'style','popupmenu',...
					'units','normal',...
					'BackgroundColor',[1 1 1],...
					'String','Mappings|Temporal',...
					'position',[0.01 0.67 0.2 0.06]);
					
ud.b1 = uicontrol(	'style','pushbutton',...
					'units','normal',...
					'BackgroundColor',[1 1 1],...
					'String','Refresh',...
					'Callback','refreshsysfigcb',...
					'position',[0.01 0.59 0.2 0.06]);

% Fill the listbox
s={};
for i=1:length(m.mapping),
	s{i} = get(m.mapping{i},'name');
end
set(ud.f1,'string',s);

set(f,'userdata',ud);
