function m=incr_test(m,in,out,par)
%FIT_LINEARS performs a incremental optimisation of the rule base
%    using a method developped by Siemens
%
%    M=INCR_TEST(M,PAR) LMS fit of the linears for each output of
%    the model M.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose   performs a incremental optimisation of the rule base
%    using a method developped by Siemens
%
%   @synopsis   m=incr_test(m,in,out,par)
%   @description  LMS fit of the linears for each output of
%   the model <CODE>m</CODE>.
%
%MAN_PAGE_END   

%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 13/09/98 11:12
%
%	All rights reserved

if (nargin<2), par=[]; end

if (~isfield(par,'ErrorCriteria') | isempty(par.ErrorCriteria)), par.ErrorCriteria=1; end
if (~isfield(par,'Thresold') | isempty(par.Thresold)), par.Thresold=1; end
if (~isfield(par,'m') | isempty(par.m)), par.m=1.5; end
if (~isfield(par,'OutputRelation') | isempty(par.OutputRelation)), par.OutputRelation=[]; end
if (~isfield(par,'FileName') | isempty(par.FileName)), par.FileName='model'; end
if (~isfield(par,'ErrorMax') | isempty(par.ErrorMax)), par.ErrorMax=0.01; end
if (~isfield(par,'n_rules_max') | isempty(par.n_rules_max)), par.n_rules_max=5; end

models=ModelCalculation([in out],get(m,'n_in'),par.n_rules_max,par.ErrorMax,par.FileName,par.OutputRelation,par.m,par.Thresold,par.ErrorCriteria);
%Plot the models error
[MeanError,MaxError] = ModelResults(models);
%Allow the user to select a model

p=[];
p.e1=MeanError;
p.e2=MaxError;
p.obj=[];
p.val=0;
set(gcf,'userdata',p);
zoom off;

set(gcf,'WindowButtonDownFcn','siemens_hook(1)');
set(gcf,'WindowButtonMotionFcn','siemens_hook(2)');
set(gcf,'WindowButtonUpFcn','siemens_hook(3)');

res=0;
while ~res,
	t=waitforbuttonpress;
	if ~t,
		params=get(gcf,'userdata');
		res = params.val;
	end
end

close(gcf);
model = models(res).Model;

m=rem_rules(m);
m=add_rules(m,res,{'productspace' 'inversedist' 'linear'});
for i=1:res,
	m.centers(:,i) = model.MembershipFunctionCenter(i,1:end-1);
	m.ivariances(:,:,i) = diag(model.ScaleFactor(1:end-1).^2);
	m.linears(:,:,i) = model.LocalLinearModel(i,:,:);
end

model.LocalLinearModel
