function m=taksug(varargin)
%TAKSUG class for implementing the taksug fuzzy functions
%    
%    The taksug class is a child of the mapping class and
%    allows the definition of a static system using a fuzzy
%    rule based Takagi-Sugeno (TS) representation.  The class
%    inherits all the fields of the mapping class and defined
%    a  series of new attibutes required for implementing the
%    TS representation of a model. At the top level the
%    following fields are defined:
%    
%      N_RULES: defines the number of fuzzy rules of the
%          model
%      MODEL_CODE: defines the structure of the fuzzy rules
%      CENTERS: position of the center of each rule
%      IVARIANCES: inverse of the projected covariance
%          matrix of the cluster associated to each rule. In
%          other words,  it is the quadratic matrix defining
%          the local metric (or  the shape) of the rule
%      LINEARS: hyperplane associated to each rule 
%          (consequence of the rule)
%      M: index of the fuzzyness of the model
%      MFS: description of the fuzzy sets while they are
%          defined along each dimension.
%      RLS: description of the rules base.
%    
%    M=TAKSUG(VARARGIN) returns an empty taksug object.
%    
%    M=TAKSUG(TAKSUG_OBJ) returns a copy of the TAKSUG_OBJ
%    object.
%    
%    M=TAKSUG(STRUCTURE) initializes a new taksug object with
%    the appropriate fields set according to the values
%    defined in the fields of STRUCTURE.
%    
%    M=TAKSUG(NAME, N_INPUTS, N_OUTPUTS) initializes a new
%    taksug object called NAME, with  number of inputs
%    N_INPUTS and number of outputs N_OUTPUTS.
%    
%    The class defines the following methods:
%    
%      ADD_RULES: adds specified number of rules
%      ADD_SETS: Add fuzzy sets along one or more dimensions
%          of the input space
%      CHECK: checks the consistency of all the field of a
%          taksug object
%      DENORMALIZE: denormalizes the model
%      DISPLAY: Display an object of class taksug
%      DRAWCONTROLS: Draw controls which allow to control
%          the plot behaviour
%      EVAL: computes the value of the model
%      FIT_LINEARS: identifies the consequent part of a
%          fuzzy model from data
%      GET: gets the value of the attribute of an object
%      IDENTIFY: identifies a fuzzy model from data
%      INTERP_MODEL: Computes a local fuzzy combination of
%          the consequents of the rules
%      JACOB_INPUTS: computes the jacobian of the model
%      JACOB_PARAMS: computes the jacobian of the model
%      LEV_MARQ: Performs a Levenbergh Marquardt
%          optimisation of the mapping
%      MEMBERSHIP: returns the membership of a rule
%      NORMALISE: normalises the model M
%      PLOT: performs a plot of the a taksug model
%      PLOT: performs a plot of the a taksug model
%      REM_RULES: remove the specified rules from the taksug
%          object
%      SET: set object properties
%      SETS_GRID: Remove every fuzzy sets and replace them
%          by evenly spaced ones
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose    class for implementing the taksug fuzzy functions.
%   The taksug class is a child of the mapping class and allows the
%   definition of a static system using a fuzzy rule based
%   Takagi-Sugeno (TS) representation. 
%   The class inherits all the fields of the mapping class and defined a 
%   series of new attibutes required for implementing the TS
%   representation of a model. At the top level the following fields are
%   defined:
%
%<dl>
%<dt>    n_rules <dd>      defines the number of fuzzy rules of the model
%<dt>    model_code <dd>  defines the structure of the fuzzy rules
%<dt>    centers <dd>     position of the center of each rule
%<dt>    ivariances <dd> inverse of the projected covariance matrix
%						of the cluster associated to each rule. In other words, 
%						it is the quadratic matrix defining the local metric (or 
%						the shape) of the rule
%
%<dt>    linears   <dd>  hyperplane associated to each rule  (consequence of the rule)
%<dt>    m      <dd>      index of the fuzzyness of the model 
%<dt>    mfs      <dd>      description of the fuzzy sets while they are defined along each dimension.
%<dt>    rls      <dd>      description of the rules base.
%</dl>
%
%   @synopsis    m=taksug(varargin)
%   @description  returns an empty taksug object.
%
%   @synopsis   m=taksug(taksug_obj)
%   @description returns a copy of the <code>taksug_obj</code> object.
%
%   @synopsis   m=taksug(structure)
%   @description initializes a new taksug object
%   with the appropriate fields set according to the values
%   defined in the fields of <code>structure</code>.
%
%   @synopsis   m=taksug(name, n_inputs, n_outputs)
%   @description initializes a new taksug
%   object called <code>name</code>, with  number of inputs <code>n_inputs</code> and
%   number of outputs <code>n_outputs</code>.
%
%
%MAN_PAGE_END

error(checkargs(varargin,[0 3],'any','numeric','numeric'));

m=[];
if nargin==0                   %if no arguments build an emty object
	m.centers = [];
  	m.ivariances = [];
  	m.linears = [];
  	m.rls = [];
  	m.mfs={};
  	m.n_rules = 0;
  	m.model_code = {};
  	m.m = 2;
  	
  	f=mapping;
  	m=class(m,'taksug',f);
  	
elseif nargin==1,              %if one argument
  if isa(varargin{1},'taksug') & isa(varargin{1}.mapping ,'mapping'),   %if type taksug clone it
    m=varargin{1};
  elseif isa(varargin{1},'mapping') & ~ isa(varargin{1},'taksug'), %if type mapping add the fields
    m.centers = [];
    m.ivariances = [];
    m.linears = [];
    m.rls = [];
    m.mfs={};
    m.n_rules = 0;
    m.model_code = {};
    m.m = 2;
    
    f=varargin{1};
    m=class(m,'taksug',f);
  else                              %if it is something else (usually for update purposes)
    m.centers = [];
    m.ivariances = [];
    m.linears = [];
    m.rls = [];
    m.mfs={};
    m.n_rules = 0;
    m.model_code = {};
    m.m = 2;
    
    f=mapping;
    
    arg = struct(varargin{1});
    
    if isfield(arg,'mapping'),
      f=mapping(arg.mapping);
      arg=rmfield(arg,'mapping');
      
      fn=fieldnames(m);
      for i=1:size(fn,1),
	if isfield(arg,fn{i}),
	  m=setfield(m,fn{i},getfield(arg,fn{i}));
	end
      end  
    end
    m=class(m,'taksug',f);
  end
elseif nargin>1,
  f=mapping(varargin{:});
  
  m.centers = [];
  m.ivariances = [];
  m.linears = [];
  m.rls = [];
  m.mfs=cell(1,get(f,'n_in'));
  m.n_rules = 0;
  m.model_code = {};
  m.m = 2;
  
  m=class(m,'taksug',f);
end



