function setup;

ver=  version;

if str2num(ver(1:3)) < 5.2
  error('You need Matlab 5.2 or later to run the software');
end
  
fprintf('Adding the Following paths to Matlab:\n');
 
loc=cd;
addpath(loc(1:end));
disp(loc);
addpath(fullfile(cd,'tools'));
disp(fullfile(cd,'tools'));
addpath(fullfile(cd,'gui'));
disp(fullfile(cd,'gui'));
addpath(fullfile(cd,'interfaces'));
disp(fullfile(cd,'interfaces'));
addpath(fullfile(cd,'tools','clustering'));
disp(fullfile(cd,'tools','clustering'));

fprintf('\nScanning your Hardware...\n');

switch computer,
case 'PCWIN',
	fprintf('Compiling mex files for a wintel PC\n');
	addpath(fullfile(cd,'tools','mex_winthell'));
	disp(fullfile(cd,'tools','mex_winthell'));
case 'MAC2',
	fprintf('Compiling mex files for a MacOS system :-)\n');
	addpath(fullfile(cd,'tools','mex_mac'));
	disp(fullfile(cd,'tools','mex_mac'));
case 'SOL2',
	fprintf('Compiling mex files for Solaris\n');
	addpath(fullfile(cd,'tools','mex_solaris'));
	disp(fullfile(cd,'tools','mex_solaris'));
case 'LNX86',
	fprintf('Compiling mex files for Linux :-)\n');
	addpath(fullfile(cd,'tools','mex_linuxpc'));
	disp(fullfile(cd,'tools','mex_linuxpc'));
otherwise
	error('Platform not supported');
end
eval('make_mex_file;');
fprintf('\n');
fprintf('\n');
fprintf('Integrating Robert Babuska''s algorithms\n see http://lcewww.et.tudelft.nl/~babuska\n')
addpath(fullfile(cd,'extern','fmid20'));
disp(fullfile(cd,'extern','fmid20'));
addpath(fullfile(cd,'extern','fmid20','privatefun'));
disp(fullfile(cd,'extern','fmid20','privatefun'));
fprintf('Integrating the lazy toolbox\n see http://iridia.ulb.ac.be/~lazy\n')
fprintf('\n');
fprintf('Installation SUCCESSFULL !\n');
fprintf('Look inside tutorials to start !\n');
