function d = addvariable(d,f)
%ADDVARIABLE Add a new variable(feature) to the data set
%    
%    D = ADDVARIABLE(D,V) adds the variable V to the dataset
%    d. Fills the corresponding data with zeros.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Add a new variable(feature) to the data set
%
%   @synopsis	d = addvariable(d,v)
%   @description  adds the variable <code>v</code> to the dataset d.
%	Fills the corresponding data with zeros.
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 19/03/99

loadfromdisk(d)

d.variables = [d.variables {f}];
d.data = [d.data nan+zeros(size(d.data,1),1)];
d.symbols = [d.symbols {{}}];
d.vartypes = [d.vartypes {'continuous'}];
