function out=classpart(d,classes)
%CLASSPART selects a part (of the classes) of the data set
%    
%    OUT=CLASSPART(D,CLASSES) allows to extracts from D the
%    data concerning the part CLASSES of the classes.
%    
%    See also: CLASSGROUP
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	selects a part (of the classes) of the data set
%
%   @synopsis	out=classpart(d,classes)
%   @description  allows to extracts from <code>d</code> the data
%	concerning the part <code>classes</code> of the classes.
%
%   @see classgroup
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 19/03/99

loadfromdisk(d)

select=[];
classcol = find(strcmp(d.vartypes,'class'));

for i=1:length(classes),
   ref = find(strcmp(d.symbols{classcol},classes{i}));
   locals = find(d.data(:,classcol) == ref);
   %The following line implies we do a copy of d which is not the most efficient
   d.data (locals,classcol) = -i;
   select=[select; locals];
end

tref.type='()';
tref.subs={select ':'};
out=subsref(d,tref);

out.data(:,classcol) = abs(out.data(:,classcol));
out.symbols{classcol} = classes(:)';
