function [d,t] = normalise(d,t)
%NORMALISE NORMALISE performs the linear normalisation of
%    a learning dataset and transforms the corresponding
%    testing dataset if it is provided
%    
%    LEARNSET = NORMALISE(LEARNSET); [LEARNSET, TESTSET] = 
%    NORMALISE(LEARNSET, TESTSET); each feature value will be
%    linearly computed between 0 and 1.
%    Algorithm
%    
%    
%    
%    See also: NORMSTD
%    
%    

%MAN_PAGE_BEGIN
%@purpose NORMALISE performs the linear normalisation of a learning dataset and transforms
% the corresponding testing dataset if it is provided.
%
%@synopsis LEARNSET = NORMALISE(LEARNSET);
% [LEARNSET, TESTSET] =  NORMALISE(LEARNSET, TESTSET);
%@description each feature value will be linearly computed between 0 and 1.<br>
% Algorithm<br>
% <br>
%    <math>newd = (d-min(d))/(max(d)-min(d))</math><br>
%@see NORMSTD
%MAN_PAGE_END

% Copyright (c) 23/03/99
% $ Revision : 1.0$ 8/08/99 Patrice Latinne

datad = get(d,'contdata');
mini = min(datad);
maxi=max(datad);
denom = maxi-mini;

ndata = (datad-mini(ones(size(datad,1),1),:))./denom(ones(size(datad,1),1),:);
set(d,'contdata',ndata);
d.opt.mini = mini;
d.opt.denom = denom;

if nargin==2
   datat= get(t,'contdata');
   ndata = (datat-mini(ones(size(datat,1),1),:))./denom(ones(size(datat,1),1),:);
   set(t,'contdata',ndata);
   d.opt.mini = mini;
   d.opt.denom = denom;
end
