function z = vertcat(varargin)
%VERTCAT vertical concatenation operator
%    
%    Z = VERTCAT(D1, D2, ...) concatenates two or more data
%    sets D1, D2 etc. Symbolic codes are reorganised in order
%    to avoid redundancies.
%    
%    See also: ALSO 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	vertical concatenation operator
%
%   @synopsis	z = vertcat(d1, d2, ...)
%   @description  concatenates two or more data sets <CODE>d1</CODE>, <CODE>d2</CODE>
%	etc. Symbolic codes are reorganised in order to avoid redundancies.
%
%   @see also 
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 19/03/99

%Skip empty objects
start = 1;
while (varargin{start}.nv == 0),
	start = start + 1;
end

z = varargin{start};

loadfromdisk(z);

for i=start+1:nargin,
	d = varargin{i};
	newdata = get_data(d);
	
	if ~isempty(newdata),
		z.labels = [z.labels;d.labels];
		
		for j=1:z.nv,
			if strcmp(z.variables{j},['f' num2str(j)]),
				z.variables{j} = d.variables{j};
			end
			if strcmp(z.vartypes{j},'continuous'),
				z.vartypes{j} = d.vartypes{j};
			end
			
			for k=1:length(d.symbols{j}),
				g = find(strcmp(z.symbols{j},d.symbols{j}{k}));
				if isempty(g),
					z.symbols{j} = [z.symbols{j} d.symbols{j}(k)];
					g = length(z.symbols{j});
				end
				if k ~= g,
					newdata(find(newdata(:,j) == k),j) = g;
				end
			end
		end
		z.data =[z.data; newdata];
	end
end

z = synccache(z);
