function [in,out]=build_regressors(z,ny,nu,nd,subset);
% BUILD_REGRESSORS
%
% build the regresors for a MIMO system
% z=[y u];
%
% in{o}(t)=[y{1}(t-1),y{1}(t-2),...,y{1}(t-ny(o,1)),y{2}(t-1),y{2}(t-2),...,y{2}(t-ny(o,2)), ...
%			u{1}(t-nd(O,1)),u{1}(t-1-nd(O,1)),...,u{1}(t-nu(o,1)-nd(O,1)), ...]
% out{o}(t)=y{o}(t)
%
% It works even if y{1} ... are all vectors (useful for the computation of the derivatives)
%
% [in,out]=build_regressors(z,ny,nu,nd,subset);
%
%	Inputs:
%		z: 			[outputs inputs]
%		ny,nu,nd: 	the dynamical parameters
%		subset:		the number of regressors that are built (from the latest data)
%
%	Outputs:
%		in, out: the input and output cell arrays

%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 11/09/98 15:48
%
%	All rights reserved


[m,n,o]=size(z);
n_out=size(ny,1);
n_in=size(nu,2);

	
for i=1:n_out,
	start_point=max(max(ny(i,:)+(ny(i,:)>0)),max(nu(i,:)+nd(i,:)));
	if nargin>4,
		start_point=max(start_point,size(z,1)-subset+1);
	end
	
	out{i}=squeeze(z(start_point:end,i,:));
	
	in{i}=[];
	
	for j=1:n_out,
		for k=1:ny(i,j),
			in{i}=[in{i} squeeze(z(start_point-k:end-k,j,:))];
		end
	end
	
	for j=1:n_in,
		for k=1:nu(i,j),
			in{i}=[in{i} squeeze(z(start_point-k-nd(i,j)+1:end-k-nd(i,j)+1,j+n_out,:))];
		end
	end
end
