function display(m)
%DISPLAY Display an object of class internal
%    
%    DISPLAY(M) Display the object m of class internal %
%    
%    See also: 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Display an object of class internal
%
%   @synopsis	display(m)
%   @description  Display the object m of class internal
%%
%   @see 
%
%MAN_PAGE_END

error(checkargs({m},1,'internal'));
ps = struct(m.system);

c = struct2cell(ps);
f = fieldnames(ps);

c = [c(1:3);{m.n_state};{m.state};c(4:9);{m.statemapping};{m.statelinks};{m.statelimits};c(10:end)];
f = [f(1:3);{'n_state'};{'state'};f(4:9);{'statemapping'};{'statelinks'};{'statelimits'};f(10:end)];

ps = cell2struct(c,f,1);

disp(' ');
disp([inputname(1),' =']);
disp(' ');
disp('A internal system with the following attributes');
disp(' ');
disp(ps);
disp(' ');
